/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.composition;

import com.g4mesoft.captureplayback.GSCapturePlaybackExtension;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.module.client.GSCapturePlaybackClientModule;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionModelView;
import com.g4mesoft.captureplayback.panel.composition.GSITrackEntrySelectionModel;
import com.g4mesoft.captureplayback.panel.composition.GSTrackEntrySelectionModel;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.event.GSFocusEvent;
import com.g4mesoft.ui.panel.event.GSIFocusEventListener;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSColorUtil;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.Iterator;
import net.minecraft.class_11906;
import net.minecraft.class_156;

public class GSCompositionPanel
extends GSPanel
implements GSIMouseListener,
GSIKeyListener,
GSIFocusEventListener,
GSIScrollable,
GSIModelViewListener {
    public static final int BACKGROUND_COLOR = -13421773;
    public static final int TRACK_SPACING_COLOR = -14540254;
    private static final int ENTRY_TITLE_HEIGHT = 10;
    private static final int ENTRY_TITLE_LEFT_MARGIN = 2;
    private static final int ENTRY_TITLE_BG_ALPHA = 224;
    private static final int ENTRY_PREVIEW_BG_ALPHA = 128;
    private static final double NORMAL_ZOOM_SPEED = 1.1;
    private static final double SLOW_ZOOM_SPEED = 1.05;
    private static final int DOTTED_LINE_LENGTH = 3;
    private static final int DOTTED_LINE_SPACING = 3;
    private static final int TIME_INDICATOR_COLOR = -14540254;
    private static final int SELECTION_BACKGROUND_COLOR = 0x40EEEEEE;
    private static final int SELECTION_BORDER_COLOR = 0x40FFFFFF;
    private static final int SELECTED_ENTRY_COLOR = -15626010;
    private static final long SLOW_INCREMENTAL_DELTA = 1L;
    private static final long FAST_INCREMENTAL_DELTA = 5L;
    private static final long DOUBLE_CLICK_TIME = 500L;
    private static final long ADD_DELETE_ENTRY_CLICK_TIME = 250L;
    private static final double RELATIVE_ZT_MARGIN = 0.35;
    private final GSComposition composition;
    private final GSCompositionModelView modelView;
    private final GSITrackEntrySelectionModel selectionModel;
    private int draggingMouseX;
    private boolean draggingEntry;
    private double selectionStartGametick;
    private int selectionStartY;
    private int selectionEndX;
    private int selectionEndY;
    private boolean selectingEntries;
    private GSTrackEntry clickedEntry;
    private GSTrack clickedTrack;
    private long leftClickTime;
    private int leftClickCount;
    private boolean editable;

    public GSCompositionPanel(GSComposition composition, GSCompositionModelView modelView) {
        this.composition = composition;
        this.modelView = modelView;
        this.selectionModel = new GSTrackEntrySelectionModel(composition);
        this.editable = true;
        this.addMouseEventListener(this);
        this.addKeyEventListener(this);
        this.addFocusEventListener(this);
    }

    protected void onShown() {
        super.onShown();
        this.resetMouseActions();
        this.modelView.addModelViewListener(this);
    }

    protected void onHidden() {
        super.onHidden();
        this.modelView.removeModelViewListener(this);
    }

    private void resetMouseActions() {
        this.draggingEntry = false;
        this.selectingEntries = false;
        this.leftClickTime = class_156.method_658();
        this.leftClickCount = 0;
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        GSRectangle bounds = renderer.getClipBounds().intersection(0, 0, this.width, this.height);
        this.renderBackground(renderer, bounds);
        this.renderTimeIndicators(renderer, bounds);
        for (GSTrack track : this.composition.getTracks()) {
            this.renderTrack(renderer, track, bounds);
        }
        this.renderSelection(renderer, bounds);
    }

    private void renderBackground(GSIRenderer2D renderer, GSRectangle bounds) {
        renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, -13421773);
    }

    private void renderTimeIndicators(GSIRenderer2D renderer, GSRectangle bounds) {
        long interval = this.modelView.getTimeIndicatorInterval();
        long subInterval = interval / 5L;
        int sy = bounds.y - bounds.y % 6;
        long gt = this.modelView.getTimeIndicatorFromX(bounds.x);
        int x = this.modelView.getGametickX(gt);
        while (x - bounds.x < bounds.width) {
            renderer.drawVLine(x, bounds.y, bounds.y + bounds.height, -14540254);
            if (subInterval != 0L) {
                for (long j = subInterval; j < interval; j += subInterval) {
                    int sx = this.modelView.getGametickX(gt + j);
                    renderer.drawDottedVLine(sx, sy, bounds.y + bounds.height, 3, 3, -14540254);
                }
            }
            x = this.modelView.getGametickX(gt += interval);
        }
    }

    private void renderTrack(GSIRenderer2D renderer, GSTrack track, GSRectangle bounds) {
        int th = this.modelView.getTrackHeight();
        int sy = this.modelView.getTrackY(track);
        if (sy + th >= bounds.y && sy - bounds.y < bounds.height) {
            for (GSTrackEntry entry : track.getEntries()) {
                this.renderEntry(renderer, entry, track.getColor(), bounds);
            }
            renderer.fillRect(bounds.x, sy + th, bounds.width, this.modelView.getTrackSpacing(), -14540254);
        }
    }

    private void renderEntry(GSIRenderer2D renderer, GSTrackEntry entry, int color, GSRectangle bounds) {
        if (this.selectionModel.isSelected(entry)) {
            color = -15626010;
        }
        GSTrack track = entry.getParent();
        GSRectangle entryBounds = this.modelView.modelToView(entry);
        if (track != null && entryBounds != null && entryBounds.intersects(bounds)) {
            int titleColor = GSColorUtil.brighter((int)color);
            int titleBgColor = GSColorUtil.withAlpha((int)GSColorUtil.darker((int)color), (int)224);
            String title = renderer.trimString(track.getSequence().getName(), entryBounds.width - 4);
            int tx = entryBounds.x + 2;
            int ty = entryBounds.y + (10 - renderer.getTextAscent()) / 2;
            renderer.fillRect(entryBounds.x, entryBounds.y, entryBounds.width, 10, titleBgColor);
            renderer.drawTextNoStyle((CharSequence)title, tx, ty, titleColor, false);
            entryBounds.y += 10;
            entryBounds.height -= 10;
            this.renderSequencePreview(renderer, entry, entryBounds, color);
        }
    }

    private void renderSequencePreview(GSIRenderer2D renderer, GSTrackEntry entry, GSRectangle bounds, int color) {
        int darkColor = GSColorUtil.darker((int)color);
        int previewBgColor = GSColorUtil.withAlpha((int)GSColorUtil.darker((int)darkColor), (int)128);
        renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, previewBgColor);
        int ztw = (int)Math.round(this.modelView.getGametickWidth() * 0.30000000000000004);
        GSTrack track = entry.getParent();
        if (track != null) {
            int entryColor = GSColorUtil.withAlpha((int)darkColor, (int)224);
            Iterator<GSChannel> channelItr = track.getSequence().getChannels().iterator();
            for (int yo = 1; yo < bounds.height && channelItr.hasNext(); yo += 2) {
                GSChannel channel = channelItr.next();
                for (GSChannelEntry channelEntry : channel.getEntries()) {
                    int x1;
                    int x0;
                    long gt1;
                    long gt0 = channelEntry.getStartTime().getGametick() + entry.getOffset();
                    if (gt0 == (gt1 = channelEntry.getEndTime().getGametick() + entry.getOffset())) {
                        x0 = this.modelView.getGametickX(gt0) + (this.modelView.getGametickWidth(gt0) - ztw) / 2;
                        x1 = Math.min(x0 + ztw, this.modelView.getGametickX(gt0 + 1L));
                    } else {
                        x0 = this.modelView.getGametickX(gt0) + this.modelView.getGametickWidth(gt0) / 2;
                        x1 = this.modelView.getGametickX(gt1) + this.modelView.getGametickWidth(gt1) / 2;
                    }
                    if (x1 - x0 <= 0) {
                        if (x1 - bounds.x > bounds.width) {
                            x0 = bounds.x + bounds.width - 1;
                        } else if (x0 < bounds.x) {
                            x0 = bounds.x;
                        }
                        x1 = x0 + 1;
                    }
                    renderer.drawHLine(x0, x1, bounds.y + yo, entryColor);
                }
            }
        }
    }

    private void renderSelection(GSIRenderer2D renderer, GSRectangle bounds) {
        if (this.selectingEntries) {
            int mx0 = this.modelView.getGametickExactX(this.selectionStartGametick);
            int my0 = this.selectionStartY;
            int sx0 = Math.min(mx0, this.selectionEndX);
            int sy0 = Math.min(my0, this.selectionEndY);
            int sx1 = Math.max(mx0, this.selectionEndX);
            int sy1 = Math.max(my0, this.selectionEndY);
            renderer.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0, 0x40EEEEEE);
            renderer.drawRect(sx0, sy0, sx1 - sx0, sy1 - sy0, 0x40FFFFFF);
        }
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(this.modelView.getMinimumWidth(), this.modelView.getMinimumHeight());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void mousePressed(GSMouseEvent event) {
        if (!(event.isConsumed() || this.selectingEntries || this.draggingEntry || event.getButton() != 0)) {
            long now = class_156.method_658();
            long dt = now - this.leftClickTime;
            this.leftClickTime = now;
            GSTrackEntry oldClickedEntry = this.clickedEntry;
            this.clickedTrack = this.modelView.getTrackFromY(event.getY());
            this.clickedEntry = this.modelView.getEntryAt(event.getX(), event.getY());
            this.leftClickCount = this.clickedEntry == oldClickedEntry && dt <= 500L ? ++this.leftClickCount : 1;
            boolean additiveSelection = event.isModifierHeld(class_11906.field_62589);
            if (additiveSelection || this.clickedEntry == null) {
                this.selectingEntries = true;
                this.selectionStartGametick = this.modelView.getGametickExactFromX(event.getX());
                this.selectionStartY = event.getY();
                this.selectionEndX = event.getX();
                this.selectionEndY = event.getY();
                this.updateSelection(additiveSelection);
                event.consume();
            } else if (this.leftClickCount == 2) {
                GSTrack track = this.clickedEntry.getParent();
                if (track != null) {
                    this.editTrackSequence(track);
                    event.consume();
                }
            } else {
                if (!this.selectionModel.isSelected(this.clickedEntry)) {
                    this.selectionModel.unselectAll();
                    this.selectionModel.select(this.clickedEntry);
                }
                if (this.editable) {
                    this.draggingMouseX = event.getX();
                    this.draggingEntry = true;
                }
                event.consume();
            }
        }
    }

    private void editTrackSequence(GSTrack track) {
        GSCapturePlaybackClientModule module = GSCapturePlaybackExtension.getInstance().getClientModule();
        module.getAssetManager().requestSession(GSESessionRequestType.REQUEST_START, track.getTrackUUID());
    }

    public void mouseReleased(GSMouseEvent event) {
        this.selectingEntries = false;
        this.draggingEntry = false;
        if (!event.isConsumed() && this.editable) {
            GSTrack track;
            long deltaMs = class_156.method_658() - this.leftClickTime;
            if (this.leftClickCount == 2 && deltaMs <= 250L && (track = this.modelView.getTrackFromY(event.getY())) != null && track == this.clickedTrack) {
                if (this.clickedEntry == null) {
                    this.addEntryAt(event.getX(), event.getY());
                    this.leftClickCount = 0;
                    event.consume();
                } else if (event.isModifierHeld(2)) {
                    this.deleteEntry(this.clickedEntry);
                    this.leftClickCount = 0;
                    event.consume();
                }
            }
        }
    }

    private void addEntryAt(int x, int y) {
        GSTrackEntry entry;
        long offset = this.modelView.getGametickFromX(x);
        GSTrack track = this.modelView.getTrackFromY(y);
        if (offset >= 0L && track != null && (entry = track.addEntry(offset)) != null) {
            this.selectionModel.unselectAll();
            this.selectionModel.select(entry);
        }
    }

    public void mouseDragged(GSMouseEvent event) {
        if (!event.isConsumed() && this.editable && this.draggingEntry) {
            long gt0 = this.modelView.getGametickFromX(this.draggingMouseX);
            long gt1 = this.modelView.getGametickFromX(event.getX());
            if (this.moveSelectedEntries(gt1 - gt0)) {
                this.leftClickCount = 0;
                this.draggingMouseX = event.getX();
                event.consume();
            }
        } else if (this.selectingEntries) {
            this.selectionEndX = event.getX();
            this.selectionEndY = event.getY();
            this.updateSelection(event.isModifierHeld(class_11906.field_62589));
            event.consume();
        }
    }

    private boolean moveSelectedEntries(long dgt) {
        if (dgt < 0L) {
            for (GSTrackEntry entry : this.selectionModel) {
                if (entry.getOffset() + dgt >= 0L) continue;
                dgt = -entry.getOffset();
            }
        }
        if (dgt != 0L) {
            for (GSTrackEntry entry : this.selectionModel) {
                entry.setOffset(entry.getOffset() + dgt);
            }
            return true;
        }
        return false;
    }

    private void updateSelection(boolean additiveSelection) {
        long gt1;
        long gt0;
        if (!additiveSelection) {
            this.selectionModel.unselectAll();
        }
        if ((gt0 = this.modelView.getGametickFromExact(this.selectionStartGametick)) > (gt1 = this.modelView.getGametickFromX(this.selectionEndX))) {
            long tmp = gt0;
            gt0 = gt1;
            gt1 = tmp;
        }
        int ch = this.modelView.getMinimumHeight();
        if (this.selectionEndY < 0 && this.selectionStartY < 0 || this.selectionEndY >= ch && this.selectionStartY >= ch) {
            return;
        }
        int my0 = GSMathUtil.clamp((int)this.selectionStartY, (int)0, (int)(ch - 1));
        int my1 = GSMathUtil.clamp((int)this.selectionEndY, (int)0, (int)(ch - 1));
        GSTrack t0 = this.modelView.getTrackFromY(my0);
        GSTrack t1 = this.modelView.getTrackFromY(my1);
        if (t0 == null || t1 == null) {
            return;
        }
        if (this.modelView.isTrackAfter(t0, t1)) {
            GSTrack tmp = t0;
            t0 = t1;
            t1 = tmp;
        }
        GSTrack track = t0;
        while (track != null && !this.modelView.isTrackAfter(track, t1)) {
            long duration = this.modelView.getSequenceDuration(track.getSequence());
            for (GSTrackEntry entry : track.getEntries()) {
                if (entry.getOffset() > gt1 || entry.getOffset() + duration <= gt0) continue;
                this.selectionModel.select(entry);
            }
            track = this.modelView.getNextTrack(track, false, false);
        }
    }

    public void mouseScrolled(GSMouseEvent event) {
        if (!event.isConsumed() && event.isModifierHeld(class_11906.field_62589) && this.isValid()) {
            double zoomSpeed = event.isModifierHeld(4) ? 1.05 : 1.1;
            double scroll = event.isModifierHeld(1) ? (double)event.getScrollX() : (double)event.getScrollY();
            this.zoomToCenter(Math.pow(zoomSpeed, scroll), event.getX());
            event.consume();
        }
    }

    private void zoomToCenter(double multiplier, int x) {
        int scrollX = GSPanelUtil.getScrollX((GSPanel)this);
        double gt = this.modelView.getGametickExactFromX(x);
        this.modelView.multiplyZoom(multiplier);
        int deltaX = this.modelView.getGametickExactX(gt) - x;
        GSPanelUtil.setScrollX((GSPanel)this, (int)(scrollX + deltaX));
    }

    public void keyPressed(GSKeyEvent event) {
        if (!event.isConsumed() && this.editable) {
            switch (event.getKeyCode()) {
                case 261: {
                    this.deleteSelection();
                    event.consume();
                    break;
                }
                case 263: {
                    boolean modifier = event.isModifierHeld(2);
                    if (!this.moveSelectedEntries(-this.getIncrementalMoveDelta(modifier))) break;
                    event.consume();
                    break;
                }
                case 262: {
                    boolean modifier = event.isModifierHeld(2);
                    if (!this.moveSelectedEntries(this.getIncrementalMoveDelta(modifier))) break;
                    event.consume();
                }
            }
        }
    }

    private long getIncrementalMoveDelta(boolean moveModifier) {
        return moveModifier ? 5L : 1L;
    }

    private void deleteSelection() {
        for (GSTrackEntry entry : this.selectionModel) {
            this.deleteEntry(entry);
        }
        this.selectionModel.unselectAll();
    }

    private void deleteEntry(GSTrackEntry entry) {
        GSTrack track = entry.getParent();
        if (track != null) {
            track.removeEntry(entry.getEntryUUID());
        }
    }

    public void focusLost(GSFocusEvent event) {
        this.resetMouseActions();
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    public boolean isScrollableHeightFilled() {
        return true;
    }

    @Override
    public void modelViewChanged() {
        this.invalidate();
    }
}

