/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.composition;

import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.panel.composition.GSITrackEntrySelectionModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;

public class GSTrackEntrySelectionModel
implements GSITrackEntrySelectionModel {
    private final GSComposition composition;
    private final Map<UUID, Set<UUID>> trackSelections;

    public GSTrackEntrySelectionModel(GSComposition composition) {
        this.composition = composition;
        this.trackSelections = new HashMap<UUID, Set<UUID>>();
    }

    @Override
    public void select(GSTrackEntry entry) {
        GSTrack track = entry.getParent();
        if (track != null) {
            Set<UUID> selections = this.trackSelections.get(track.getTrackUUID());
            if (selections == null) {
                selections = new HashSet<UUID>();
                this.trackSelections.put(track.getTrackUUID(), selections);
            }
            selections.add(entry.getEntryUUID());
        }
    }

    @Override
    public void unselect(GSTrackEntry entry) {
        Set<UUID> selections;
        GSTrack track = entry.getParent();
        if (track != null && (selections = this.trackSelections.get(track.getTrackUUID())) != null) {
            selections.remove(entry.getEntryUUID());
            if (selections.isEmpty()) {
                this.trackSelections.remove(track.getTrackUUID());
            }
        }
    }

    @Override
    public void unselectAll() {
        this.trackSelections.clear();
    }

    @Override
    public boolean isSelected(GSTrackEntry entry) {
        GSTrack track = entry.getParent();
        if (track != null) {
            Set<UUID> selections = this.trackSelections.get(track.getTrackUUID());
            return selections != null && selections.contains(entry.getEntryUUID());
        }
        return false;
    }

    @Override
    public boolean hasSelection() {
        return !this.trackSelections.isEmpty();
    }

    @Override
    public Iterator<GSTrackEntry> iterator() {
        return new GSSelectionIterator();
    }

    final class GSSelectionIterator
    implements Iterator<GSTrackEntry> {
        private final Iterator<Map.Entry<UUID, Set<UUID>>> trackIterator;
        private GSTrack currentTrack;
        private Iterator<UUID> entryIterator;
        private GSTrackEntry nextEntry;

        public GSSelectionIterator() {
            this.trackIterator = GSTrackEntrySelectionModel.this.trackSelections.entrySet().iterator();
            this.currentTrack = null;
            this.entryIterator = null;
        }

        @Override
        public boolean hasNext() {
            return this.findNextEntry() != null;
        }

        @Override
        public GSTrackEntry next() {
            GSTrackEntry entry = this.findNextEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.nextEntry = null;
            return entry;
        }

        private GSTrackEntry findNextEntry() {
            while (this.nextEntry == null) {
                if (this.currentTrack == null) {
                    if (this.trackIterator.hasNext()) {
                        Map.Entry<UUID, Set<UUID>> entry = this.trackIterator.next();
                        this.currentTrack = GSTrackEntrySelectionModel.this.composition.getTrack(entry.getKey());
                        this.entryIterator = entry.getValue().iterator();
                    }
                    if (this.currentTrack == null) {
                        return null;
                    }
                }
                UUID entryUUID = this.entryIterator.next();
                this.nextEntry = this.currentTrack.getEntry(entryUUID);
                if (this.entryIterator.hasNext()) continue;
                this.currentTrack = null;
                this.entryIterator = null;
            }
            return this.nextEntry;
        }
    }
}

