/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.panel.sequence.GSSequenceModelView;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.scroll.GSIScrollBarModel;
import com.g4mesoft.ui.panel.scroll.GSScrollBar;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.renderer.GSTexture;
import com.g4mesoft.ui.util.GSColorUtil;
import net.minecraft.class_2960;

public class GSSequencePreviewScrollBar
extends GSScrollBar {
    private static final class_2960 TEXTURE_IDENTIFIER = class_2960.method_60655((String)"g4mespeed-capture-playback", (String)"textures/scroll_bar_preview.png");
    private static final GSTexture SCROLL_BUTTON_TEXTURE = new GSTexture(TEXTURE_IDENTIFIER, 30, 54);
    private static final int PREVIEW_BACKGROUND = -15263977;
    private static final int VERTICAL_BORDER_COLOR = -16382458;
    private static final int DISABLED_KNOB_COLOR = 0x40333333;
    private static final int HOVERED_KNOB_COLOR = 0x40DDDDDD;
    private static final int KNOB_COLOR = 0x40888888;
    private static final int PREVIEW_CHANNEL_COUNT = 25;
    private static final int VERTICAL_BORDER_HEIGHT = 1;
    private static final int SCROLL_BUTTON_WIDTH = 10;
    private static final int SCROLL_BUTTON_HEIGHT = 27;
    private final GSSequence sequence;
    private final GSSequenceModelView modelView;
    private int previewOffsetY;
    private final GSRectangle tmpEntryRect;

    public GSSequencePreviewScrollBar(GSSequence sequence, GSSequenceModelView modelView) {
        this.sequence = sequence;
        this.modelView = modelView;
        this.tmpEntryRect = new GSRectangle();
        this.setVertical(false);
    }

    protected int getScrollButtonSpriteX(boolean left, boolean hovered) {
        return this.isEnabled() ? (hovered ? 10 : 0) : 20;
    }

    protected int getScrollButtonSpriteY(boolean left, boolean hovered) {
        return left ? 0 : 27;
    }

    protected GSTexture getScrollButtonTexture() {
        return SCROLL_BUTTON_TEXTURE;
    }

    protected void drawKnobArea(GSIRenderer2D renderer) {
        this.renderPreview(renderer, 10, 0, this.width - 20, this.height);
    }

    private void renderPreview(GSIRenderer2D renderer, int x, int y, int width, int height) {
        GSIScrollBarModel vModel;
        float scrollInterval;
        GSScrollBar vScrollBar;
        this.previewOffsetY = 0;
        int hiddenChannelCount = this.sequence.getChannels().size() - 25;
        if (hiddenChannelCount > 0 && (vScrollBar = this.getVerticalScrollBar()) != null && (scrollInterval = (vModel = vScrollBar.getModel()).getMaxScroll() - vModel.getMinScroll()) > 0.0f && hiddenChannelCount > 0) {
            float normalizedScroll = vModel.getScroll() / scrollInterval;
            this.previewOffsetY = Math.round((float)hiddenChannelCount * normalizedScroll);
        }
        renderer.fillRect(x, y, width, height, -16382458);
        renderer.fillRect(x, ++y, width, height -= 2, -15263977);
        for (GSChannel channel : this.sequence.getChannels()) {
            if (!this.isChannelVisible(channel, x, y, width, height)) continue;
            this.renderChannelPreview(renderer, channel, x, y, width, height);
        }
    }

    private boolean isChannelVisible(GSChannel channel, int x, int y, int width, int height) {
        int channelY = this.modelView.getChannelY(channel.getChannelUUID());
        if (channelY == -1) {
            return false;
        }
        int mappedChannelY = this.mapEntryY(channelY);
        return mappedChannelY >= y && mappedChannelY < y + height;
    }

    private void renderChannelPreview(GSIRenderer2D renderer, GSChannel channel, int x, int y, int width, int height) {
        int color = GSColorUtil.darker((int)channel.getInfo().getColor());
        for (GSChannelEntry entry : channel.getEntries()) {
            GSRectangle bounds = this.getMappedEntryBounds(entry);
            if (bounds == null || !this.clampEntryBounds(bounds, x, y, width, height)) continue;
            renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, color);
        }
    }

    private boolean clampEntryBounds(GSRectangle bounds, int x, int y, int width, int height) {
        if (bounds.x < x) {
            bounds.width += bounds.x - x;
            bounds.x = x;
        }
        if (bounds.y < y) {
            bounds.height += bounds.y - y;
            bounds.y = y;
        }
        if (bounds.x + bounds.width > x + width) {
            bounds.width -= bounds.x + bounds.width - (x + width);
        }
        if (bounds.y + bounds.height > y + height) {
            bounds.height -= bounds.y + bounds.height - (y + height);
        }
        return bounds.width > 0 && bounds.height > 0;
    }

    protected int getKnobColor(boolean hovered) {
        if (!this.isEnabled()) {
            return 0x40333333;
        }
        if (this.scrollDragActive || hovered) {
            return 0x40DDDDDD;
        }
        return 0x40888888;
    }

    private GSRectangle getMappedEntryBounds(GSChannelEntry entry) {
        GSRectangle bounds = this.modelView.modelToView(entry, this.tmpEntryRect);
        return bounds == null ? null : this.mapEntryBounds(bounds);
    }

    private GSRectangle mapEntryBounds(GSRectangle bounds) {
        if (bounds.width <= 0 || bounds.height <= 0) {
            return null;
        }
        int x1 = bounds.x + bounds.width;
        int y1 = bounds.y + bounds.height;
        bounds.x = this.mapEntryX(bounds.x);
        bounds.y = this.mapEntryY(bounds.y);
        bounds.width = Math.max(1, this.mapEntryX(x1) - bounds.x);
        bounds.height = Math.max(1, this.mapEntryY(y1) - bounds.y);
        return bounds;
    }

    private int mapEntryX(int x) {
        float scrollInterval = this.model.getMaxScroll() - this.model.getMinScroll();
        x = Math.round((float)(x * this.knobAreaSize) / (scrollInterval + (float)this.viewSize));
        return 10 + x;
    }

    private int mapEntryY(int y) {
        y /= this.modelView.getChannelHeight() + this.modelView.getChannelSpacing();
        return 1 + (y -= this.previewOffsetY);
    }

    private GSScrollBar getVerticalScrollBar() {
        GSPanel parent = this.getParent();
        if (parent instanceof GSScrollPanel) {
            return ((GSScrollPanel)parent).getVerticalScrollBar();
        }
        return null;
    }

    protected GSDimension calculatePreferredSize() {
        int w = Math.max(27, this.getButtonWidth());
        int h = this.getMinimumNobSize() + this.getButtonHeight() * 2;
        return this.isVertical() ? new GSDimension(w, h) : new GSDimension(h, w);
    }

    protected int getButtonWidth() {
        return 27;
    }

    protected int getButtonHeight() {
        return 10;
    }

    public void setVertical(boolean ignore) {
        super.setVertical(false);
    }
}

