/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.util.GSUUIDUtil;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GSChannel {
    public static final boolean DEFAULT_DISABLED = false;
    private final UUID channelUUID;
    private GSChannelInfo info;
    private boolean disabled;
    private final Map<UUID, GSChannelEntry> entries;
    private GSSequence parent;

    GSChannel(GSChannel other) {
        this(other.getChannelUUID(), other.getInfo());
        this.disabled = other.isDisabled();
        for (GSChannelEntry entry : other.getEntries()) {
            this.addEntryInternal(new GSChannelEntry(entry));
        }
    }

    GSChannel(UUID channelUUID, GSChannelInfo info) {
        if (channelUUID == null) {
            throw new IllegalArgumentException("Channel UUID must not be null!");
        }
        if (info == null) {
            throw new IllegalArgumentException("Info must not be null!");
        }
        this.channelUUID = channelUUID;
        this.info = info;
        this.disabled = false;
        this.entries = new LinkedHashMap<UUID, GSChannelEntry>();
        this.parent = null;
    }

    public GSSequence getParent() {
        return this.parent;
    }

    void onAdded(GSSequence parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Channel already has a parent");
        }
        this.parent = parent;
    }

    void onRemoved(GSSequence parent) {
        if (this.parent != parent) {
            throw new IllegalStateException("Channel does not have specified parent");
        }
        this.parent = null;
    }

    void duplicateFrom(GSChannel other) {
        this.clear();
        this.setInfo(other.getInfo());
        this.setDisabled(other.isDisabled());
        for (GSChannelEntry entry : other.getEntries()) {
            UUID entryUUID = GSUUIDUtil.randomUnique(this::hasEntryUUID);
            GSChannelEntry entryCopy = new GSChannelEntry(entryUUID, entry.getStartTime(), entry.getEndTime());
            this.addEntryInternal(entryCopy);
            this.dispatchEntryAdded(entryCopy);
            entryCopy.set(entry);
        }
    }

    void set(GSChannel other) {
        this.clear();
        this.setInfo(other.getInfo());
        this.setDisabled(other.isDisabled());
        for (GSChannelEntry entry : other.getEntries()) {
            GSChannelEntry entryCopy = new GSChannelEntry(entry.getEntryUUID(), entry.getStartTime(), entry.getEndTime());
            this.addEntryInternal(entryCopy);
            this.dispatchEntryAdded(entryCopy);
            entryCopy.set(entry);
        }
    }

    private void clear() {
        Iterator<GSChannelEntry> itr = this.entries.values().iterator();
        while (itr.hasNext()) {
            GSChannelEntry entry = itr.next();
            itr.remove();
            this.onEntryRemoved(entry);
        }
    }

    public GSChannelEntry tryAddEntry(GSSignalTime startTime, GSSignalTime endTime) {
        return this.tryAddEntry(GSUUIDUtil.randomUnique(this::hasEntryUUID), startTime, endTime);
    }

    public GSChannelEntry tryAddEntry(UUID entryUUID, GSSignalTime startTime, GSSignalTime endTime) {
        if (entryUUID == null || this.hasEntryUUID(entryUUID)) {
            return null;
        }
        if (this.isOverlappingEntries(startTime, endTime, null)) {
            return null;
        }
        GSChannelEntry entry = new GSChannelEntry(entryUUID, startTime, endTime);
        this.addEntryInternal(entry);
        this.dispatchEntryAdded(entry);
        return entry;
    }

    private void addEntryInternal(GSChannelEntry entry) {
        entry.onAdded(this);
        this.entries.put(entry.getEntryUUID(), entry);
    }

    public boolean removeEntry(UUID entryUUID) {
        GSChannelEntry entry = this.entries.remove(entryUUID);
        if (entry != null) {
            this.onEntryRemoved(entry);
            return true;
        }
        return false;
    }

    private void onEntryRemoved(GSChannelEntry entry) {
        this.dispatchEntryRemoved(entry);
        entry.onRemoved(this);
    }

    public boolean isOverlappingEntries(GSSignalTime startTime, GSSignalTime endTime, GSChannelEntry ignoreEntry) {
        if (startTime.isAfter(endTime)) {
            return false;
        }
        for (GSChannelEntry other : this.entries.values()) {
            if (other == ignoreEntry || !other.isOverlapping(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    public GSChannelEntry getEntryAt(GSSignalTime time, boolean preciseSearch) {
        for (GSChannelEntry entry : this.entries.values()) {
            if (!entry.containsTimestamp(time, preciseSearch)) continue;
            return entry;
        }
        return null;
    }

    public void setInfo(GSChannelInfo info) {
        if (info == null) {
            throw new NullPointerException("Info must not be null!");
        }
        GSChannelInfo oldInfo = this.info;
        if (!oldInfo.equals(info)) {
            this.info = info;
            this.dispatchChannelInfoChanged(this, oldInfo);
        }
    }

    public GSChannelInfo getInfo() {
        return this.info;
    }

    public void setDisabled(boolean disabled) {
        boolean oldDisabled = this.disabled;
        if (oldDisabled != disabled) {
            this.disabled = disabled;
            this.dispatchChannelDisabledChanged(this, oldDisabled);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public UUID getChannelUUID() {
        return this.channelUUID;
    }

    public GSChannelEntry getEntry(UUID entryUUID) {
        return this.entries.get(entryUUID);
    }

    public boolean hasEntryUUID(UUID entryUUID) {
        return this.entries.containsKey(entryUUID);
    }

    public Set<UUID> getEntryUUIDs() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public Collection<GSChannelEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    private void dispatchChannelInfoChanged(GSChannel channel, GSChannelInfo oldInfo) {
        if (this.parent != null) {
            for (GSISequenceListener listener : this.parent.getListeners()) {
                listener.channelInfoChanged(channel, oldInfo);
            }
        }
    }

    private void dispatchChannelDisabledChanged(GSChannel channel, boolean oldDisabled) {
        if (this.parent != null) {
            for (GSISequenceListener listener : this.parent.getListeners()) {
                listener.channelDisabledChanged(channel, oldDisabled);
            }
        }
    }

    private void dispatchEntryAdded(GSChannelEntry entry) {
        if (this.parent != null) {
            for (GSISequenceListener listener : this.parent.getListeners()) {
                listener.entryAdded(entry);
            }
        }
    }

    private void dispatchEntryRemoved(GSChannelEntry entry) {
        if (this.parent != null) {
            for (GSISequenceListener listener : this.parent.getListeners()) {
                listener.entryRemoved(entry);
            }
        }
    }

    public static GSChannel read(GSDecodeBuffer buf) throws IOException {
        UUID channelUUID = buf.readUUID();
        GSChannelInfo info = GSChannelInfo.read(buf);
        GSChannel channel = new GSChannel(channelUUID, info);
        channel.setDisabled(buf.readBoolean());
        int entryCount = buf.readInt();
        while (entryCount-- != 0) {
            GSChannelEntry entry = GSChannelEntry.read(buf);
            if (channel.hasEntryUUID(entry.getEntryUUID())) {
                throw new IOException("Duplicate entry UUID");
            }
            if (channel.isOverlappingEntries(entry.getStartTime(), entry.getEndTime(), null)) {
                throw new IOException("Overlapping entry");
            }
            channel.addEntryInternal(entry);
        }
        return channel;
    }

    public static void write(GSEncodeBuffer buf, GSChannel channel) throws IOException {
        buf.writeUUID(channel.getChannelUUID());
        GSChannelInfo.write(buf, channel.getInfo());
        buf.writeBoolean(channel.isDisabled());
        Collection<GSChannelEntry> entries = channel.getEntries();
        buf.writeInt(entries.size());
        for (GSChannelEntry entry : entries) {
            GSChannelEntry.write(buf, entry);
        }
    }
}

