/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2338;

public final class GSChannelInfo {
    private static final int MAX_POSITION_COUNT = 65535;
    private final String name;
    private final int color;
    private final Set<class_2338> positions;

    public GSChannelInfo(String name, int color, class_2338 position) {
        this(name, color, Collections.singleton(position), true);
    }

    public GSChannelInfo(String name, int color, Set<class_2338> positions) {
        this(name, color, positions, false);
    }

    public GSChannelInfo(String name, int color, Set<class_2338> positions, boolean immutable) {
        if (positions.isEmpty() || positions.size() > 65535) {
            throw new IllegalArgumentException("Insufficient or too many positions");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.color = color | 0xFF000000;
        if (immutable) {
            this.positions = positions;
        } else {
            this.positions = new LinkedHashSet<class_2338>();
            for (class_2338 position : positions) {
                this.positions.add(position.method_10062());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public Set<class_2338> getPositions() {
        return Collections.unmodifiableSet(this.positions);
    }

    public GSChannelInfo withName(String name) {
        return new GSChannelInfo(name, this.color, this.positions, true);
    }

    public GSChannelInfo withColor(int color) {
        return new GSChannelInfo(this.name, color, this.positions, true);
    }

    public GSChannelInfo withPositions(Set<class_2338> positions) {
        return new GSChannelInfo(this.name, this.color, positions, false);
    }

    public GSChannelInfo addPosition(class_2338 position) {
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>(this.positions);
        positions.add(position.method_10062());
        return new GSChannelInfo(this.name, this.color, positions, true);
    }

    public GSChannelInfo removePosition(class_2338 position) {
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>(this.positions);
        positions.remove(position);
        return new GSChannelInfo(this.name, this.color, positions, true);
    }

    public GSChannelInfo withOffsetPositions(int dx, int dy, int dz) {
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>();
        for (class_2338 pos : this.positions) {
            positions.add(pos.method_10069(dx, dy, dz));
        }
        return new GSChannelInfo(this.name, this.color, positions, true);
    }

    public boolean equals(GSChannelInfo other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.color != other.color) {
            return false;
        }
        return this.positions.equals(other.positions);
    }

    public boolean equals(Object other) {
        if (other instanceof GSChannelInfo) {
            return this.equals((GSChannelInfo)other);
        }
        return false;
    }

    public static GSChannelInfo read(GSDecodeBuffer buf) throws IOException {
        String name = buf.readString();
        int color = buf.readUnsignedMedium();
        int positionCount = buf.readUnsignedShort();
        if (positionCount == 0 || positionCount > 65535) {
            throw new IOException("Insufficient or too many positions");
        }
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>(positionCount);
        while (positionCount-- != 0) {
            positions.add(buf.readBlockPos());
        }
        return new GSChannelInfo(name, color, positions, true);
    }

    public static void write(GSEncodeBuffer buf, GSChannelInfo info) throws IOException {
        buf.writeString(info.name);
        buf.writeMedium(info.color);
        buf.writeUnsignedShort(info.positions.size());
        for (class_2338 position : info.positions) {
            buf.writeBlockPos(position);
        }
    }
}

