/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

public enum GSEChannelEntryType {
    EVENT_BOTH(0, "panel.sequencecontent.typeboth"),
    EVENT_START(1, "panel.sequencecontent.typestart"),
    EVENT_END(2, "panel.sequencecontent.typeend"),
    EVENT_NONE(3, "panel.sequencecontent.typenone");

    public static final GSEChannelEntryType[] TYPES;
    private final int index;
    private final String name;

    private GSEChannelEntryType(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public boolean hasStartEvent() {
        return this == EVENT_BOTH || this == EVENT_START;
    }

    public boolean hasEndEvent() {
        return this == EVENT_BOTH || this == EVENT_END;
    }

    public GSEChannelEntryType toggleStart() {
        switch (this.ordinal()) {
            case 0: {
                return EVENT_END;
            }
            case 1: {
                return EVENT_NONE;
            }
            case 2: {
                return EVENT_BOTH;
            }
            case 3: {
                return EVENT_START;
            }
        }
        throw new IllegalStateException("Missing type");
    }

    public GSEChannelEntryType toggleEnd() {
        switch (this.ordinal()) {
            case 0: {
                return EVENT_START;
            }
            case 1: {
                return EVENT_BOTH;
            }
            case 2: {
                return EVENT_NONE;
            }
            case 3: {
                return EVENT_END;
            }
        }
        throw new IllegalStateException("Missing type");
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static GSEChannelEntryType fromIndex(int index) {
        if (index < 0 || index >= TYPES.length) {
            return null;
        }
        return TYPES[index];
    }

    static {
        TYPES = new GSEChannelEntryType[GSEChannelEntryType.values().length];
        GSEChannelEntryType[] gSEChannelEntryTypeArray = GSEChannelEntryType.values();
        int n = gSEChannelEntryTypeArray.length;
        for (int i = 0; i < n; ++i) {
            GSEChannelEntryType type;
            GSEChannelEntryType.TYPES[type.index] = type = gSEChannelEntryTypeArray[i];
        }
    }
}

