/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequenceCaptureStream;
import com.g4mesoft.captureplayback.sequence.GSSequencePlaybackStream;
import com.g4mesoft.captureplayback.stream.GSBlockRegion;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.util.GSMutableLinkedHashMap;
import com.g4mesoft.captureplayback.util.GSUUIDUtil;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;

public class GSSequence {
    private final UUID sequenceUUID;
    private String name;
    private final GSMutableLinkedHashMap<UUID, GSChannel> channels;
    private List<GSISequenceListener> listeners;

    public GSSequence(GSSequence other) {
        this(other.getSequenceUUID(), other.getName());
        for (GSChannel channel : other.getChannels()) {
            this.addChannelInternal(new GSChannel(channel));
        }
    }

    public GSSequence(UUID sequenceUUID) {
        this(sequenceUUID, "");
    }

    public GSSequence(UUID sequenceUUID, String name) {
        if (sequenceUUID == null) {
            throw new IllegalArgumentException("sequenceUUID is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.sequenceUUID = sequenceUUID;
        this.name = name;
        this.channels = new GSMutableLinkedHashMap();
        this.listeners = null;
    }

    public void duplicateFrom(GSSequence other) {
        if (!this.channels.isEmpty()) {
            throw new IllegalStateException("Expected an empty sequence");
        }
        for (GSChannel channel : other.getChannels()) {
            this.addChannel(channel.getInfo()).duplicateFrom(channel);
        }
    }

    public void set(GSSequence other) {
        this.clear();
        this.setName(other.getName());
        for (GSChannel channel : other.getChannels()) {
            this.addChannel(channel.getChannelUUID(), channel.getInfo()).set(channel);
        }
    }

    private void clear() {
        Iterator<GSChannel> itr = this.channels.values().iterator();
        UUID prevUUID = null;
        while (itr.hasNext()) {
            GSChannel channel = itr.next();
            itr.remove();
            this.onChannelRemoved(channel, prevUUID);
            prevUUID = channel.getChannelUUID();
        }
    }

    public GSChannel addChannel(GSChannelInfo info) {
        return this.addChannel(GSUUIDUtil.randomUnique(this::hasChannelUUID), info);
    }

    public GSChannel addChannel(UUID channelUUID, GSChannelInfo info) {
        if (this.hasChannelUUID(channelUUID)) {
            throw new IllegalStateException("Duplicate channel UUID");
        }
        GSChannel channel = new GSChannel(channelUUID, info);
        this.addChannelInternal(channel);
        GSChannel prevChannel = this.getPreviousChannel(channelUUID);
        UUID prevUUID = prevChannel == null ? null : prevChannel.getChannelUUID();
        this.dispatchChannelAdded(channel, prevUUID);
        return channel;
    }

    private void addChannelInternal(GSChannel channel) {
        channel.onAdded(this);
        this.channels.put(channel.getChannelUUID(), channel);
    }

    public boolean removeChannel(UUID channelUUID) {
        GSChannel prevChannel = this.getPreviousChannel(channelUUID);
        GSChannel channel = this.channels.remove(channelUUID);
        if (channel != null) {
            UUID prevUUID = prevChannel == null ? null : prevChannel.getChannelUUID();
            this.onChannelRemoved(channel, prevUUID);
            return true;
        }
        return false;
    }

    private void onChannelRemoved(GSChannel channel, UUID oldPrevUUID) {
        this.dispatchChannelRemoved(channel, oldPrevUUID);
        channel.onRemoved(this);
    }

    public void moveChannelBefore(UUID channelUUID, UUID newNextUUID) {
        GSChannel prevChannel = this.getPreviousChannel(newNextUUID);
        this.moveChannelAfter(channelUUID, prevChannel == null ? null : prevChannel.getChannelUUID());
    }

    public void moveChannelAfter(UUID channelUUID, UUID newPrevUUID) {
        if (channelUUID != null) {
            Map.Entry<UUID, GSChannel> entry;
            UUID oldPrevUUID;
            Map.Entry<UUID, GSChannel> prevEntry = this.channels.getPreviousEntry(channelUUID);
            UUID uUID = oldPrevUUID = prevEntry == null ? null : prevEntry.getKey();
            if (!channelUUID.equals(newPrevUUID) && (entry = this.channels.moveAfter(channelUUID, newPrevUUID)) != null) {
                this.dispatchChannelMoved(entry.getValue(), newPrevUUID, oldPrevUUID);
            }
        }
    }

    public GSChannel getPreviousChannel(UUID channelUUID) {
        Map.Entry<UUID, GSChannel> prevEntry = this.channels.getPreviousEntry(channelUUID);
        return prevEntry == null ? null : prevEntry.getValue();
    }

    public GSChannel getNextChannel(UUID channelUUID) {
        Map.Entry<UUID, GSChannel> nextEntry = this.channels.getNextEntry(channelUUID);
        return nextEntry == null ? null : nextEntry.getValue();
    }

    public UUID getSequenceUUID() {
        return this.sequenceUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.dispatchSequenceNameChanged(oldName);
        }
    }

    public GSChannel getChannel(UUID channelUUID) {
        return this.channels.get(channelUUID);
    }

    public boolean hasChannelUUID(UUID channelUUID) {
        return this.channels.containsKey(channelUUID);
    }

    public Set<UUID> getChannelUUIDs() {
        return Collections.unmodifiableSet(this.channels.keySet());
    }

    public Collection<GSChannel> getChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    public void addSequenceListener(GSISequenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<GSISequenceListener>();
        }
        this.listeners.add(listener);
    }

    public void removeSequenceListener(GSISequenceListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    Iterable<GSISequenceListener> getListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    private void dispatchSequenceNameChanged(String oldName) {
        for (GSISequenceListener listener : this.getListeners()) {
            listener.sequenceNameChanged(oldName);
        }
    }

    private void dispatchChannelAdded(GSChannel channel, UUID prevUUID) {
        for (GSISequenceListener listener : this.getListeners()) {
            listener.channelAdded(channel, prevUUID);
        }
    }

    private void dispatchChannelRemoved(GSChannel channel, UUID oldPrevUUID) {
        for (GSISequenceListener listener : this.getListeners()) {
            listener.channelRemoved(channel, oldPrevUUID);
        }
    }

    private void dispatchChannelMoved(GSChannel channel, UUID newPrevUUID, UUID oldPrevUUID) {
        for (GSISequenceListener listener : this.getListeners()) {
            listener.channelMoved(channel, newPrevUUID, oldPrevUUID);
        }
    }

    public static GSSequence read(GSDecodeBuffer buf) throws IOException {
        buf.readByte();
        UUID sequenceUUID = buf.readUUID();
        String name = buf.readString();
        GSSequence sequence = new GSSequence(sequenceUUID, name);
        int channelCount = buf.readInt();
        while (channelCount-- != 0) {
            GSChannel channel = GSChannel.read(buf);
            if (sequence.hasChannelUUID(channel.getChannelUUID())) {
                throw new IOException("Duplicate channel UUID.");
            }
            sequence.addChannelInternal(channel);
        }
        return sequence;
    }

    public static void write(GSEncodeBuffer buf, GSSequence sequence) throws IOException {
        buf.writeByte((byte)0);
        buf.writeUUID(sequence.getSequenceUUID());
        buf.writeString(sequence.getName());
        Collection<GSChannel> channels = sequence.getChannels();
        buf.writeInt(channels.size());
        for (GSChannel channel : channels) {
            GSChannel.write(buf, channel);
        }
    }

    public GSIPlaybackStream getPlaybackStream() {
        return new GSSequencePlaybackStream(this);
    }

    public GSICaptureStream getCaptureStream() {
        return new GSSequenceCaptureStream(this);
    }

    public GSBlockRegion getBlockRegion() {
        int x0 = Integer.MAX_VALUE;
        int y0 = Integer.MAX_VALUE;
        int z0 = Integer.MAX_VALUE;
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        int z1 = Integer.MIN_VALUE;
        for (GSChannel channel : this.getChannels()) {
            for (class_2338 position : channel.getInfo().getPositions()) {
                if (position.method_10263() < x0) {
                    x0 = position.method_10263();
                }
                if (position.method_10264() < y0) {
                    y0 = position.method_10264();
                }
                if (position.method_10260() < z0) {
                    z0 = position.method_10260();
                }
                if (position.method_10263() > x1) {
                    x1 = position.method_10263();
                }
                if (position.method_10264() > y1) {
                    y1 = position.method_10264();
                }
                if (position.method_10260() <= z1) continue;
                z1 = position.method_10260();
            }
        }
        return new GSBlockRegion(x0, y0, z0, x1, y1, z1);
    }

    public class_2338 getOrigin() {
        return this.getBlockRegion().getPos0();
    }

    public void offsetOrigin(int dx, int dy, int dz) {
        if (dx != 0 || dy != 0 || dz != 0) {
            for (GSChannel channel : this.getChannels()) {
                channel.setInfo(channel.getInfo().withOffsetPositions(dx, dy, dz));
            }
        }
    }
}

