/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelAddedDelta
extends GSChannelDelta {
    private UUID prevUUID;
    private GSChannelInfo info;

    public GSChannelAddedDelta() {
    }

    public GSChannelAddedDelta(GSChannel channel, UUID prevUUID) {
        this(channel.getChannelUUID(), prevUUID, channel.getInfo());
    }

    public GSChannelAddedDelta(UUID channelUUID, UUID prevUUID, GSChannelInfo info) {
        super(channelUUID);
        if (info == null) {
            throw new IllegalArgumentException("info is null");
        }
        this.prevUUID = prevUUID;
        this.info = info;
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.removeChannel(sequence, this.prevUUID, this.info, false, 0);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.addChannel(sequence, this.prevUUID, this.info);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.info = GSChannelInfo.read(buf);
        this.prevUUID = buf.readBoolean() ? buf.readUUID() : null;
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        GSChannelInfo.write(buf, this.info);
        buf.writeBoolean(this.prevUUID != null);
        if (this.prevUUID != null) {
            buf.writeUUID(this.prevUUID);
        }
    }
}

