/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelDisabledDelta
extends GSChannelDelta {
    private boolean newDisabled;
    private boolean oldDisabled;

    public GSChannelDisabledDelta() {
    }

    public GSChannelDisabledDelta(UUID channelUUID, boolean newDisabled, boolean oldDisabled) {
        super(channelUUID);
        this.newDisabled = newDisabled;
        this.oldDisabled = oldDisabled;
    }

    private void setChannelDisabled(boolean newDisabled, boolean oldDisabled, GSSequence sequence) throws GSDeltaException {
        GSChannel channel = this.getChannel(sequence);
        this.checkChannelDisabled(channel, oldDisabled);
        channel.setDisabled(newDisabled);
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.setChannelDisabled(this.oldDisabled, this.newDisabled, sequence);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.setChannelDisabled(this.newDisabled, this.oldDisabled, sequence);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newDisabled = buf.readBoolean();
        this.oldDisabled = buf.readBoolean();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeBoolean(this.newDisabled);
        buf.writeBoolean(this.oldDisabled);
    }
}

