/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelEntryAddedDelta
extends GSChannelEntryDelta {
    private GSSignalTime startTime;
    private GSSignalTime endTime;

    public GSChannelEntryAddedDelta() {
    }

    public GSChannelEntryAddedDelta(GSChannelEntry entry) {
        this(entry.getParent().getChannelUUID(), entry.getEntryUUID(), entry.getStartTime(), entry.getEndTime());
    }

    public GSChannelEntryAddedDelta(UUID channelUUID, UUID entryUUID, GSSignalTime startTime, GSSignalTime endTime) {
        super(channelUUID, entryUUID);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.removeEntry(sequence, this.startTime, this.endTime, GSChannelEntry.DEFAULT_ENTRY_TYPE);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.addEntry(sequence, this.startTime, this.endTime);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.startTime = GSSignalTime.read(buf);
        this.endTime = GSSignalTime.read(buf);
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        GSSignalTime.write(buf, this.startTime);
        GSSignalTime.write(buf, this.endTime);
    }
}

