/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public abstract class GSChannelEntryDelta
extends GSChannelDelta {
    protected UUID entryUUID;

    protected GSChannelEntryDelta() {
    }

    protected GSChannelEntryDelta(UUID channelUUID, UUID entryUUID) {
        super(channelUUID);
        this.entryUUID = entryUUID;
    }

    protected GSChannelEntry getEntry(GSSequence sequence) throws GSDeltaException {
        return this.getEntry(this.getChannel(sequence));
    }

    protected GSChannelEntry getEntry(GSChannel channel) throws GSDeltaException {
        GSChannelEntry entry = channel.getEntry(this.entryUUID);
        if (entry == null) {
            throw new GSDeltaException("Expected entry does not exist");
        }
        return entry;
    }

    protected void checkEntryTimespan(GSChannelEntry entry, GSSignalTime startTime, GSSignalTime endTime) throws GSDeltaException {
        if (!entry.getStartTime().isEqual(startTime) || !entry.getEndTime().isEqual(endTime)) {
            throw new GSDeltaException("Entry does not have the expected timespan");
        }
    }

    protected void checkEntryType(GSChannelEntry entry, GSEChannelEntryType type) throws GSDeltaException {
        if (entry.getType() != type) {
            throw new GSDeltaException("Entry does not have the expected type");
        }
    }

    protected void removeEntry(GSSequence sequence, GSSignalTime startTime, GSSignalTime endTime, GSEChannelEntryType expectedType) throws GSDeltaException {
        GSChannelEntry entry = this.getEntry(sequence);
        this.checkEntryTimespan(entry, startTime, endTime);
        this.checkEntryType(entry, expectedType);
        entry.getParent().removeEntry(this.entryUUID);
    }

    protected GSChannelEntry addEntry(GSSequence sequence, GSSignalTime startTime, GSSignalTime endTime) throws GSDeltaException {
        GSChannel channel = this.getChannel(sequence);
        if (channel.hasEntryUUID(this.entryUUID)) {
            throw new GSDeltaException("Entry already exists");
        }
        GSChannelEntry entry = null;
        try {
            entry = channel.tryAddEntry(this.entryUUID, startTime, endTime);
        }
        catch (Throwable t) {
            channel.removeEntry(this.entryUUID);
        }
        if (entry == null) {
            throw new GSDeltaException("Unable to add entry");
        }
        return entry;
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.entryUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeUUID(this.entryUUID);
    }
}

