/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelEntryRemovedDelta
extends GSChannelEntryDelta {
    private GSSignalTime startTime;
    private GSSignalTime endTime;
    private GSEChannelEntryType type;

    public GSChannelEntryRemovedDelta() {
    }

    public GSChannelEntryRemovedDelta(GSChannelEntry entry) {
        this(entry.getParent().getChannelUUID(), entry.getEntryUUID(), entry.getStartTime(), entry.getEndTime(), entry.getType());
    }

    public GSChannelEntryRemovedDelta(UUID channelUUID, UUID entryUUID, GSSignalTime startTime, GSSignalTime endTime, GSEChannelEntryType type) {
        super(channelUUID, entryUUID);
        this.startTime = startTime;
        this.endTime = endTime;
        this.type = type;
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        GSChannelEntry entry = this.addEntry(sequence, this.startTime, this.endTime);
        entry.setType(this.type);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.removeEntry(sequence, this.startTime, this.endTime, this.type);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.startTime = GSSignalTime.read(buf);
        this.endTime = GSSignalTime.read(buf);
        this.type = GSEChannelEntryType.fromIndex(buf.readInt());
        if (this.type == null) {
            throw new IOException("Type index invalid");
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        GSSignalTime.write(buf, this.startTime);
        GSSignalTime.write(buf, this.endTime);
        buf.writeInt(this.type.getIndex());
    }
}

