/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryRemovedDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;

public class GSChannelRemovedDelta
extends GSChannelDelta {
    private UUID prevUUID;
    private GSChannelInfo info;
    private boolean disabled;
    private GSChannelEntryRemovedDelta[] entryDeltas;

    public GSChannelRemovedDelta() {
    }

    public GSChannelRemovedDelta(GSChannel channel, UUID prevUUID) {
        this(channel.getChannelUUID(), prevUUID, channel.getInfo(), channel.isDisabled(), channel.getEntries());
    }

    public GSChannelRemovedDelta(UUID channelUUID, UUID prevUUID, GSChannelInfo info, boolean disabled, Collection<GSChannelEntry> entries) {
        super(channelUUID);
        this.prevUUID = prevUUID;
        this.info = info;
        this.disabled = disabled;
        this.entryDeltas = new GSChannelEntryRemovedDelta[entries.size()];
        int i = 0;
        for (GSChannelEntry entry : entries) {
            this.entryDeltas[i++] = new GSChannelEntryRemovedDelta(entry);
        }
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        GSChannel channel = this.addChannel(sequence, this.prevUUID, this.info);
        channel.setDisabled(this.disabled);
        for (GSChannelEntryRemovedDelta entryDelta : this.entryDeltas) {
            entryDelta.unapply(sequence);
        }
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.removeChannel(sequence, this.prevUUID, this.info, this.disabled, this.entryDeltas.length);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.info = GSChannelInfo.read(buf);
        this.disabled = buf.readBoolean();
        this.entryDeltas = new GSChannelEntryRemovedDelta[buf.readInt()];
        for (int i = 0; i < this.entryDeltas.length; ++i) {
            this.entryDeltas[i] = new GSChannelEntryRemovedDelta();
            this.entryDeltas[i].read(buf);
        }
        this.prevUUID = buf.readBoolean() ? buf.readUUID() : null;
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        GSChannelInfo.write(buf, this.info);
        buf.writeBoolean(this.disabled);
        buf.writeInt(this.entryDeltas.length);
        for (GSChannelEntryRemovedDelta entryDelta : this.entryDeltas) {
            entryDelta.write(buf);
        }
        buf.writeBoolean(this.prevUUID != null);
        if (this.prevUUID != null) {
            buf.writeUUID(this.prevUUID);
        }
    }
}

