/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Objects;

public class GSSequenceNameDelta
implements GSIDelta<GSSequence> {
    private String newName;
    private String oldName;

    public GSSequenceNameDelta() {
    }

    public GSSequenceNameDelta(String newName, String oldName) {
        this.newName = newName;
        this.oldName = oldName;
    }

    private void setName(String newName, String oldName, GSSequence sequence) throws GSDeltaException {
        if (!Objects.equals(oldName, sequence.getName())) {
            throw new GSDeltaException("Sequence does not have the expected name");
        }
        sequence.setName(newName);
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.setName(this.oldName, this.newName, sequence);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.setName(this.newName, this.oldName, sequence);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.newName = buf.readString();
        this.oldName = buf.readString();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeString(this.newName);
        buf.writeString(this.oldName);
    }
}

