/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSDeltaRegistries;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.session.GSIUndoRedoEntry;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public class GSCompositionUndoRedoEntry
implements GSIUndoRedoEntry {
    private GSIDelta<GSComposition> delta;
    private long timestampMillis;

    GSCompositionUndoRedoEntry() {
    }

    public GSCompositionUndoRedoEntry(GSIDelta<GSComposition> delta) {
        this(delta, System.currentTimeMillis());
    }

    public GSCompositionUndoRedoEntry(GSIDelta<GSComposition> delta, long timestampMillis) {
        this.delta = delta;
        this.timestampMillis = timestampMillis;
    }

    private GSComposition getComposition(GSSession session) throws GSDeltaException {
        GSComposition composition = session.get(GSSession.COMPOSITION);
        if (composition == null) {
            throw new GSDeltaException("Session does not contain a composition");
        }
        return composition;
    }

    @Override
    public void undo(GSSession session) throws GSDeltaException {
        this.delta.unapply(this.getComposition(session));
    }

    @Override
    public void redo(GSSession session) throws GSDeltaException {
        this.delta.apply(this.getComposition(session));
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.delta = GSDeltaRegistries.COMPOSITION_DELTA_REGISTRY.read(buf);
        this.timestampMillis = buf.readLong();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        GSDeltaRegistries.COMPOSITION_DELTA_REGISTRY.write(buf, this.delta);
        buf.writeLong(this.timestampMillis);
    }

    @Override
    public long getTimestampMillis() {
        return this.timestampMillis;
    }
}

