/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.session.GSISessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSSessionField;
import java.util.function.Function;
import java.util.function.Supplier;

public class GSSessionFieldType<T> {
    private final String name;
    private final Function<GSSessionFieldType<T>, GSSessionField<T>> constructor;
    private final Supplier<T> defaultSupplier;
    private final boolean nullable;
    private final boolean assignOnce;
    private final GSISessionFieldCodec<T> codec;
    private final boolean cached;
    private final boolean synced;

    public GSSessionFieldType(String name, Function<GSSessionFieldType<T>, GSSessionField<T>> constructor, Supplier<T> defaultSupplier, boolean nullable, boolean assignOnce, GSISessionFieldCodec<T> codec, boolean cached, boolean synced) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        if (codec == null) {
            throw new IllegalArgumentException("codec is null");
        }
        if (defaultSupplier == null) {
            throw new IllegalArgumentException("defaultSupplier is null");
        }
        this.name = name;
        this.constructor = constructor;
        this.defaultSupplier = defaultSupplier;
        this.nullable = nullable;
        this.assignOnce = assignOnce;
        this.codec = codec;
        this.cached = cached;
        this.synced = synced;
    }

    public String getName() {
        return this.name;
    }

    public GSSessionField<T> create() {
        GSSessionField<T> field = this.constructor.apply(this);
        T value = this.defaultSupplier.get();
        if (!this.nullable && value == null) {
            throw new IllegalStateException("value is null");
        }
        field.set(value);
        return field;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isAssignableOnce() {
        return this.assignOnce;
    }

    public GSISessionFieldCodec<T> getCodec() {
        return this.codec;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!GSSessionFieldType.class.equals(other.getClass())) {
            return false;
        }
        return this.name.equals(((GSSessionFieldType)other).name);
    }
}

