/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSISessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSSessionField;
import com.g4mesoft.captureplayback.session.GSSessionFieldType;
import com.google.common.base.Suppliers;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public final class GSSessionFieldTypeBuilder<T> {
    private static final Supplier<Object> NULL_SUPPLIER = Suppliers.ofInstance(null);
    private final Map<String, GSSessionFieldType<?>> nameToType;
    private final Map<GSESessionType, Set<GSSessionFieldType<?>>> sessionFieldTypes;
    private String name;
    private Function<GSSessionFieldType<T>, GSSessionField<T>> constructor;
    private Supplier<T> defaultSupplier;
    private boolean nullable;
    private boolean assignOnce;
    private GSISessionFieldCodec<T> codec;
    private boolean cached;
    private boolean synced;
    private final Set<GSESessionType> sessionTypes;
    private boolean hasName;
    private boolean hasDefaultSupplier;
    private boolean hasCodec;

    public GSSessionFieldTypeBuilder(Map<String, GSSessionFieldType<?>> nameToType, Map<GSESessionType, Set<GSSessionFieldType<?>>> sessionFieldTypes) {
        this.nameToType = nameToType;
        this.sessionFieldTypes = sessionFieldTypes;
        this.sessionTypes = EnumSet.noneOf(GSESessionType.class);
        this.reset();
    }

    private void reset() {
        this.name = null;
        this.constructor = GSSessionField::new;
        Supplier<Object> nullSupplier = NULL_SUPPLIER;
        this.defaultSupplier = nullSupplier;
        this.nullable = false;
        this.assignOnce = false;
        this.codec = null;
        this.cached = true;
        this.synced = true;
        this.sessionTypes.clear();
        this.hasName = false;
        this.hasDefaultSupplier = false;
        this.hasCodec = false;
    }

    public GSSessionFieldTypeBuilder<T> name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.hasName = true;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> constr(Function<GSSessionFieldType<T>, GSSessionField<T>> constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        this.constructor = constructor;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> def(T defaultValue) {
        return this.def((Supplier<T>)Suppliers.ofInstance(defaultValue));
    }

    public GSSessionFieldTypeBuilder<T> def(Supplier<T> defaultSupplier) {
        if (defaultSupplier == null) {
            throw new IllegalArgumentException("defaultSupplier is null");
        }
        this.defaultSupplier = defaultSupplier;
        this.hasDefaultSupplier = true;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> nullable() {
        this.nullable = true;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> assignOnce() {
        this.assignOnce = true;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> codec(GSISessionFieldCodec<T> codec) {
        this.codec = codec;
        this.hasCodec = true;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> noCache() {
        this.cached = false;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> noSync() {
        this.synced = false;
        return this;
    }

    public GSSessionFieldTypeBuilder<T> session(GSESessionType sessionType) {
        this.sessionTypes.add(sessionType);
        return this;
    }

    public GSSessionFieldType<T> build() {
        if (!this.hasName) {
            throw new IllegalStateException("must specify a name");
        }
        if (!this.nullable && !this.hasDefaultSupplier) {
            throw new IllegalStateException("must specify a default supplier");
        }
        if (!this.hasCodec) {
            throw new IllegalStateException("must specify a codec");
        }
        if (this.sessionTypes.isEmpty()) {
            throw new IllegalStateException("must specify a session type");
        }
        GSSessionFieldType<T> type = new GSSessionFieldType<T>(this.name, this.constructor, this.defaultSupplier, this.nullable, this.assignOnce, this.codec, this.cached, this.synced);
        if (this.nameToType.put(this.name, type) != null) {
            throw new IllegalStateException("Duplicate type with name: " + this.name);
        }
        for (GSESessionType sessionType : this.sessionTypes) {
            Set<GSSessionFieldType<?>> types = this.sessionFieldTypes.get((Object)sessionType);
            if (types == null) {
                types = new HashSet();
                this.sessionFieldTypes.put(sessionType, types);
            }
            types.add(type);
        }
        this.reset();
        return type;
    }

    public <V> GSSessionFieldTypeBuilder<V> cast() {
        GSSessionFieldTypeBuilder builder = this;
        return builder;
    }
}

