/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSSessionField;
import com.g4mesoft.captureplayback.session.GSSessionFieldPair;
import com.g4mesoft.captureplayback.session.GSSessionFieldType;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import com.google.common.base.Predicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;

class GSSessionFields
implements Iterable<GSSessionFieldPair<?>> {
    private GSSession session;
    private final Map<GSSessionFieldType<?>, GSSessionField<?>> fields;

    private GSSessionFields() {
        this(null);
    }

    public GSSessionFields(GSSession session) {
        this.session = session;
        this.fields = new HashMap();
    }

    public <T> boolean contains(GSSessionFieldType<T> field) {
        return this.fields.containsKey(field);
    }

    <T> boolean add(GSSessionFieldType<T> type) {
        GSSessionField<T> field = this.getField(type);
        if (field == null) {
            field = type.create();
            this.fields.put(type, field);
            field.onAdded(this.session);
            return true;
        }
        return false;
    }

    <T> void forceSet(GSSessionFieldPair<T> pair) {
        GSSessionField<T> field = this.getField(pair.getType());
        if (field != null) {
            field.set(pair.getValue());
        }
    }

    public <T> boolean set(GSSessionFieldType<T> type, T value) {
        if (!type.isNullable() && value == null) {
            throw new IllegalArgumentException("value is null");
        }
        GSSessionField<T> field = this.getField(type);
        if (field != null && !Objects.equals(field.get(), value)) {
            if (type.isAssignableOnce() && field.get() != null) {
                throw new IllegalStateException("value already assigned");
            }
            field.set(value);
            return true;
        }
        return false;
    }

    public <T> T get(GSSessionFieldType<T> type) {
        GSSessionField<T> field = this.getField(type);
        return field == null ? null : (T)field.get();
    }

    <T> GSSessionField<T> getField(GSSessionFieldType<T> type) {
        GSSessionField<?> field = this.fields.get(type);
        return field;
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<GSSessionFieldPair<?>> iterator() {
        return new GSSessionFieldIterator(this);
    }

    public static GSSessionFields read(GSDecodeBuffer buf) throws IOException {
        GSSessionFields fields = new GSSessionFields();
        int fieldCount = buf.readInt();
        while (fieldCount-- != 0) {
            GSSessionFieldType<?> type;
            int sizeInBytes = buf.readInt();
            int location = buf.getLocation();
            try {
                type = GSSession.readFieldType(buf);
            }
            catch (IOException e) {
                buf.skipBytes(sizeInBytes - (buf.getLocation() - location));
                continue;
            }
            GSSessionFieldPair pair = new GSSessionFieldPair(type, GSSession.readField(buf, type));
            if (fields.contains(pair.getType())) {
                throw new IOException("Duplicate field type");
            }
            fields.add(pair.getType());
            fields.forceSet(pair);
        }
        return fields;
    }

    public static void write(GSEncodeBuffer buf, GSSessionFields fields) throws IOException {
        GSSessionFields.write(buf, fields, Predicates.alwaysTrue());
    }

    public static void write(GSEncodeBuffer buf, GSSessionFields fields, Predicate<GSSessionFieldType<?>> fieldFilter) throws IOException {
        ByteBuf fieldBuffer = Unpooled.buffer();
        ArrayList pairsToWrite = new ArrayList(fields.getSize());
        for (GSSessionFieldPair<Object> pair : fields) {
            if (!fieldFilter.test(pair.getType())) continue;
            pairsToWrite.add(pair);
        }
        buf.writeInt(pairsToWrite.size());
        for (GSSessionFieldPair<Object> pair : pairsToWrite) {
            GSSession.writeFieldPair(GSEncodeBuffer.wrap((ByteBuf)fieldBuffer), pair);
            buf.writeInt(fieldBuffer.readableBytes());
            buf.writeBytes(fieldBuffer);
        }
        fieldBuffer.release();
    }

    public class GSSessionFieldIterator
    implements Iterator<GSSessionFieldPair<?>> {
        private Iterator<Map.Entry<GSSessionFieldType<?>, GSSessionField<?>>> fieldItr;

        public GSSessionFieldIterator(GSSessionFields this$0) {
            this.fieldItr = this$0.fields.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fieldItr.hasNext();
        }

        @Override
        public GSSessionFieldPair<?> next() {
            if (!this.fieldItr.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<GSSessionFieldType<?>, GSSessionField<?>> entry = this.fieldItr.next();
            return new GSSessionFieldPair(entry.getKey(), entry.getValue().get());
        }

        @Override
        public void remove() {
            this.fieldItr.remove();
        }
    }
}

