/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.stream;

import com.g4mesoft.captureplayback.common.GSESignalEdge;
import com.g4mesoft.captureplayback.common.GSETickPhase;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import net.minecraft.class_2338;

public final class GSPlaybackEntry
implements Comparable<GSPlaybackEntry> {
    private final long playbackTime;
    private final GSSignalEvent event;

    public GSPlaybackEntry(class_2338 pos, GSSignalTime time, int subordering, GSESignalEdge edge, boolean shadow) {
        this.playbackTime = time.getGametick();
        this.event = new GSSignalEvent(GSETickPhase.BLOCK_EVENTS, time.getMicrotick(), subordering, edge, pos, shadow);
    }

    public long getPlaybackTime() {
        return this.playbackTime;
    }

    public GSSignalEvent getEvent() {
        return this.event;
    }

    @Override
    public int compareTo(GSPlaybackEntry other) {
        if (this.playbackTime < other.playbackTime) {
            return -1;
        }
        if (this.playbackTime > other.playbackTime) {
            return 1;
        }
        return this.event.compareTo(other.event);
    }

    public int hashCode() {
        int hash = 0;
        hash += 31 * hash + Long.hashCode(this.playbackTime);
        hash += 31 * hash + this.event.hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GSPlaybackEntry)) {
            return false;
        }
        GSPlaybackEntry entry = (GSPlaybackEntry)other;
        if (this.playbackTime != entry.playbackTime) {
            return false;
        }
        return this.event.equals(entry.event);
    }
}

