/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common;

import com.g4mesoft.captureplayback.common.GSAbstractStream;
import com.g4mesoft.captureplayback.common.GSESignalEdge;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.stream.GSBlockRegion;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;

public abstract class GSCaptureStream
extends GSAbstractStream
implements GSICaptureStream {
    private final GSBlockRegion blockRegion;
    private final Map<class_2338, List<GSChannelCapture>> posToCaptures;
    private long captureTime;
    private long latestEventTime;
    private boolean closed;

    public GSCaptureStream(GSBlockRegion blockRegion) {
        this.blockRegion = blockRegion;
        this.posToCaptures = new HashMap<class_2338, List<GSChannelCapture>>();
        this.latestEventTime = 0L;
        this.captureTime = 0L;
        this.closed = false;
    }

    protected void addChannelCapture(GSChannel channel, long offset) {
        for (class_2338 position : channel.getInfo().getPositions()) {
            List<GSChannelCapture> captures = this.posToCaptures.get(position);
            if (captures == null) {
                captures = new ArrayList<GSChannelCapture>(2);
                this.posToCaptures.put(position, captures);
            }
            captures.add(new GSChannelCapture(channel, offset));
        }
    }

    @Override
    public void write(GSISignalFrame frame) {
        if (!this.isClosed()) {
            boolean triggered = false;
            if (frame.hasNext()) {
                this.latestEventTime = this.captureTime;
                do {
                    GSSignalEvent event;
                    List<GSChannelCapture> captures;
                    if ((captures = this.posToCaptures.get((event = frame.next()).getPos())) == null) continue;
                    triggered = true;
                    for (GSChannelCapture capture : captures) {
                        capture.onEvent(this.captureTime, event);
                    }
                } while (frame.hasNext());
            }
            if (this.captureTime != 0L || triggered) {
                ++this.captureTime;
            }
        }
    }

    @Override
    public GSBlockRegion getBlockRegion() {
        return this.blockRegion;
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            for (List<GSChannelCapture> captures : this.posToCaptures.values()) {
                for (GSChannelCapture capture : captures) {
                    capture.onClose(this.latestEventTime);
                }
            }
            this.dispatchCloseEvent();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    private static class GSChannelCapture {
        private final GSChannel channel;
        private final long offset;
        private GSSignalTime risingTime;
        private boolean risingShadow;

        public GSChannelCapture(GSChannel channel, long offset) {
            this.channel = channel;
            this.offset = offset;
            this.risingTime = null;
        }

        private void onEvent(long captureTime, GSSignalEvent event) {
            if ((captureTime -= this.offset) < 0L) {
                return;
            }
            GSSignalTime time = new GSSignalTime(captureTime, event.getMicrotick());
            if (event.getEdge() == GSESignalEdge.RISING_EDGE) {
                if (this.risingTime != null && !this.risingShadow) {
                    this.addEntry(this.risingTime, this.risingTime, GSEChannelEntryType.EVENT_START);
                }
                this.risingTime = time;
                this.risingShadow = event.isShadow();
            } else if (this.risingTime == null) {
                this.addEntry(time, time, GSEChannelEntryType.EVENT_END);
            } else {
                if (!this.risingShadow || !event.isShadow()) {
                    GSEChannelEntryType type = this.risingShadow || event.isShadow() ? (this.risingShadow ? GSEChannelEntryType.EVENT_END : GSEChannelEntryType.EVENT_START) : GSEChannelEntryType.EVENT_BOTH;
                    this.addEntry(this.risingTime, time, type);
                }
                this.risingTime = null;
                this.risingShadow = false;
            }
        }

        private void addEntry(GSSignalTime startTime, GSSignalTime endTime, GSEChannelEntryType type) {
            GSChannelEntry entry = this.channel.tryAddEntry(startTime, endTime);
            if (entry != null && type != GSEChannelEntryType.EVENT_BOTH) {
                entry.setType(type);
            }
        }

        private void onClose(long latestTime) {
            if ((latestTime -= this.offset) < 0L) {
                return;
            }
            if (this.risingTime != null && !this.risingShadow) {
                GSSignalTime endTime = this.risingTime.getGametick() == latestTime ? this.risingTime : new GSSignalTime(latestTime, 0);
                this.addEntry(this.risingTime, endTime, GSEChannelEntryType.EVENT_START);
                this.risingTime = null;
                this.risingShadow = false;
            }
        }
    }
}

