/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common;

import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.GSIDeltaListener;
import java.util.ArrayList;
import java.util.List;

public abstract class GSDeltaTransformer<M> {
    protected M model = null;
    private final List<GSIDeltaListener<M>> listeners = new ArrayList<GSIDeltaListener<M>>();
    private boolean enabled = true;

    public void install(M model) {
        if (this.model != null) {
            throw new IllegalStateException("Already installed");
        }
        this.model = model;
    }

    public void uninstall(M model) {
        if (this.model == null) {
            throw new IllegalStateException("Not installed");
        }
        if (this.model != model) {
            throw new IllegalStateException("Model is not the one that is installed");
        }
        this.model = null;
    }

    public void addDeltaListener(GSIDeltaListener<M> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public void removeDeltaListener(GSIDeltaListener<M> listener) {
        this.listeners.remove(listener);
    }

    protected void dispatchDeltaEvent(GSIDelta<M> delta) {
        if (this.isEnabled()) {
            for (GSIDeltaListener<M> listener : this.listeners) {
                listener.onDelta(delta);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

