/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.CapturePlaybackMod;
import com.g4mesoft.captureplayback.common.asset.GSAbstractPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSAssetFileHeader;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSAssetStorage;
import com.g4mesoft.captureplayback.common.asset.GSCompositionAsset;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistoryListener;
import com.g4mesoft.captureplayback.common.asset.GSIAssetStorageListener;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCacheListener;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntry;
import com.g4mesoft.captureplayback.common.asset.GSSequenceAsset;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.util.GSUUIDUtil;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.ui.util.GSPathUtil;
import com.g4mesoft.util.GSFileUtil;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class GSAssetManager
implements GSIAssetStorageListener {
    private static final String ASSET_DIRECTORY_NAME = "assets";
    private final GSIServerModuleManager manager;
    private final GSAssetStorage[] storages;
    private final GSIAssetHistory combinedHistory;
    private final GSIPlayerCache playerCache;
    private final List<GSIAssetStorageListener> listeners;

    public GSAssetManager(GSIServerModuleManager manager) {
        this.manager = manager;
        GSEAssetNamespace[] namespaces = GSEAssetNamespace.values();
        this.storages = new GSAssetStorage[namespaces.length];
        for (GSEAssetNamespace namespace : namespaces) {
            GSAssetStorage storage;
            File dir = this.getAssetDirectory(namespace);
            this.storages[namespace.getIndex()] = storage = new GSAssetStorage(manager, namespace, dir);
            storage.addListener(this);
        }
        this.combinedHistory = new GSCombinedAssetHistory(this.storages);
        this.playerCache = new GSCombinedPlayerCache(this.storages);
        this.listeners = new ArrayList<GSIAssetStorageListener>();
    }

    public void init() {
        for (GSAssetStorage storage : this.storages) {
            if (storage.getNamespace() == GSEAssetNamespace.GLOBAL) continue;
            storage.init();
        }
        GSAssetStorage globalStorage = this.getStorage(GSEAssetNamespace.GLOBAL);
        if (!globalStorage.init()) {
            try {
                this.loadOldStorageFormat();
            }
            catch (IOException e) {
                CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load old storage format", (Throwable)e);
            }
        }
    }

    private void loadOldStorageFormat() throws IOException {
        File dir = new File(this.manager.getCacheFile(), "compositions");
        try {
            if (dir.isDirectory()) {
                block10: for (File file : dir.listFiles()) {
                    String fileExt;
                    if (!file.isFile() || (fileExt = GSPathUtil.getFileExtension((String)file.getName())) == null) continue;
                    switch (fileExt) {
                        case "gcomp": {
                            this.loadOldCompositionFormat(file);
                            continue block10;
                        }
                        case "gsq": {
                            this.loadOldSequenceFormat(file);
                        }
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private void loadOldCompositionFormat(File assetFile) throws IOException {
        UUID assetUUID;
        GSAssetRef ref;
        GSComposition composition;
        if ("default_composition.gcomp".equals(assetFile.getName())) {
            return;
        }
        try {
            composition = (GSComposition)GSFileUtil.readFile((File)assetFile, GSComposition::read);
        }
        catch (IOException e) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load old composition {}", (Object)assetFile.getName());
            return;
        }
        String name = composition.getName();
        if (name.isEmpty()) {
            name = this.getOldAssetFileName(assetFile);
        }
        if ((ref = this.requestAsset(assetUUID = this.createAsset(GSEAssetType.COMPOSITION, GSEAssetNamespace.GLOBAL, name, GSAssetInfo.UNKNOWN_OWNER_UUID))) != null && ref.get() instanceof GSCompositionAsset) {
            GSCompositionAsset asset = (GSCompositionAsset)ref.get();
            asset.getComposition().duplicateFrom(composition);
        }
        ref.release();
    }

    private void loadOldSequenceFormat(File assetFile) {
        UUID assetUUID;
        GSAssetRef ref;
        GSSequence sequence;
        if ("active_sequence.gsq".equals(assetFile.getName())) {
            return;
        }
        try {
            sequence = (GSSequence)GSFileUtil.readFile((File)assetFile, GSSequence::read);
        }
        catch (IOException e) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load old sequence {}", (Object)assetFile.getName());
            return;
        }
        String name = sequence.getName();
        if (name.isEmpty()) {
            name = this.getOldAssetFileName(assetFile);
        }
        if ((ref = this.requestAsset(assetUUID = this.createAsset(GSEAssetType.SEQUENCE, GSEAssetNamespace.GLOBAL, name, GSAssetInfo.UNKNOWN_OWNER_UUID))) != null && ref.get() instanceof GSSequenceAsset) {
            GSSequenceAsset asset = (GSSequenceAsset)ref.get();
            asset.getSequence().duplicateFrom(sequence);
        }
        ref.release();
    }

    private String getOldAssetFileName(File assetFile) {
        String name = assetFile.getName();
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx != -1) {
            return name.substring(0, dotIdx);
        }
        return name;
    }

    private File getAssetDirectory(GSEAssetNamespace namespace) {
        switch (namespace) {
            case GLOBAL: {
                return this.getAssetDirectory(this.manager.getCacheFile());
            }
            case WORLD: {
                return this.getAssetDirectory(this.manager.getWorldCacheFile());
            }
        }
        throw new IllegalStateException("Unknown namespace: " + String.valueOf((Object)namespace));
    }

    private File getAssetDirectory(File cacheDirectory) {
        return new File(cacheDirectory, ASSET_DIRECTORY_NAME);
    }

    public void addListener(GSIAssetStorageListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public void removeListener(GSIAssetStorageListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasAssetHandle(GSAssetHandle handle) {
        return this.getStorage(handle.getNamespace()).hasAssetHandle(handle);
    }

    public boolean hasAsset(UUID assetUUID) {
        return this.getStorage(assetUUID) != null;
    }

    public GSAssetInfo getInfo(UUID assetUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        return storage != null ? storage.getInfo(assetUUID) : null;
    }

    public GSAssetInfo getInfoFromHandle(GSAssetHandle handle) {
        return this.getStorage(handle.getNamespace()).getInfoFromHandle(handle);
    }

    public boolean isLoaded(UUID assetUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        return storage != null && storage.isLoaded(assetUUID);
    }

    public boolean hasPermission(class_3222 player, UUID assetUUID) {
        GSAssetInfo info = this.getInfo(assetUUID);
        return info != null && info.hasPermission((class_1657)player);
    }

    public boolean hasPermission(class_3222 player, GSAssetHandle handle) {
        GSAssetInfo info = this.getInfoFromHandle(handle);
        return info != null && info.hasPermission((class_1657)player);
    }

    public boolean hasExtendedPermission(class_3222 player, UUID assetUUID) {
        GSAssetInfo info = this.getInfo(assetUUID);
        return info != null && info.hasExtendedPermission((class_1657)player);
    }

    public boolean hasExtendedPermission(class_3222 player, GSAssetHandle handle) {
        GSAssetInfo info = this.getInfoFromHandle(handle);
        return info != null && info.hasExtendedPermission((class_1657)player);
    }

    public UUID createAsset(GSEAssetType type, GSEAssetNamespace namespace, String name, UUID ownerUUID) {
        GSAssetHandle handle = GSAssetHandle.fromNameUnique(namespace, name, this::hasAssetHandle);
        return this.createAsset(type, handle, name, ownerUUID);
    }

    public UUID createAsset(GSEAssetType type, GSAssetHandle handle, String name, UUID createdByUUID) {
        if (this.hasAssetHandle(handle)) {
            handle = GSAssetHandle.fromNameUnique(handle.getNamespace(), name, this::hasAssetHandle);
        }
        UUID assetUUID = GSUUIDUtil.randomUnique(this::hasAsset);
        GSAssetStorage storage = this.getStorage(handle.getNamespace());
        storage.createAsset(new GSAssetInfo(type, assetUUID, handle, name, System.currentTimeMillis(), createdByUUID, createdByUUID));
        return assetUUID;
    }

    public UUID createDuplicateAsset(GSEAssetNamespace namespace, String name, UUID ownerUUID, UUID originalAssetUUID) {
        GSAssetHandle handle = GSAssetHandle.fromNameUnique(namespace, name, this::hasAssetHandle);
        return this.createDuplicateAsset(handle, name, ownerUUID, originalAssetUUID);
    }

    public UUID createDuplicateAsset(GSAssetHandle handle, String name, UUID ownerUUID, UUID originalAssetUUID) {
        if (this.hasAssetHandle(handle)) {
            handle = GSAssetHandle.fromNameUnique(handle.getNamespace(), name, this::hasAssetHandle);
        }
        GSAssetRef ref = this.requestAsset(originalAssetUUID);
        GSAssetInfo info = this.getInfo(originalAssetUUID);
        if (ref == null || info == null) {
            throw new IllegalArgumentException("Original asset does not exist");
        }
        GSAssetHandle fHandle = handle;
        UUID assetUUID = GSUUIDUtil.randomUnique(this::hasAsset);
        GSAssetStorage storage = this.getStorage(fHandle.getNamespace());
        storage.createDuplicateAsset(new GSAssetInfo(ref.get().getType(), assetUUID, fHandle, name, System.currentTimeMillis(), info.getCreatedByUUID(), ownerUUID), ref.get());
        ref.release();
        return assetUUID;
    }

    public void deleteAsset(UUID assetUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        if (storage != null) {
            storage.deleteAsset(assetUUID);
        }
    }

    public UUID importAsset(GSEAssetNamespace namespace, String name, UUID ownerUUID, GSDecodedAssetFile assetFile) {
        GSAssetHandle handle = GSAssetHandle.fromNameUnique(namespace, name, this::hasAssetHandle);
        return this.importAsset(handle, name, ownerUUID, assetFile);
    }

    public UUID importAsset(GSAssetHandle handle, String name, UUID ownerUUID, GSDecodedAssetFile assetFile) {
        if (this.hasAssetHandle(handle)) {
            handle = GSAssetHandle.fromNameUnique(handle.getNamespace(), name, this::hasAssetHandle);
        }
        GSAssetHandle fHandle = handle;
        GSAssetFileHeader header = assetFile.getHeader();
        UUID assetUUID = GSUUIDUtil.randomUnique(this::hasAsset);
        GSAssetStorage storage = this.getStorage(fHandle.getNamespace());
        storage.importAsset(new GSAssetInfo(header.getType(), assetUUID, fHandle, name, header.getCreatedTimestamp(), header.getCreatedByUUID(), ownerUUID), assetFile);
        return assetUUID;
    }

    public void addCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        if (storage != null) {
            storage.addCollaborator(assetUUID, collabUUID);
        }
    }

    public void removeCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        if (storage != null) {
            storage.removeCollaborator(assetUUID, collabUUID);
        }
    }

    public GSAssetRef requestAsset(UUID assetUUID) {
        GSAssetStorage storage = this.getStorage(assetUUID);
        return storage != null ? storage.requestAsset(assetUUID) : null;
    }

    public void unloadAll() {
        for (GSAssetStorage storage : this.storages) {
            storage.unloadAll();
        }
    }

    public GSIAssetHistory getStoredHistory() {
        return this.combinedHistory;
    }

    public GSIPlayerCache getPlayerCache() {
        return this.playerCache;
    }

    private GSAssetStorage getStorage(GSEAssetNamespace namespace) {
        return this.storages[namespace.getIndex()];
    }

    private GSAssetStorage getStorage(UUID assetUUID) {
        for (GSAssetStorage storage : this.storages) {
            if (!storage.hasAsset(assetUUID)) continue;
            return storage;
        }
        return null;
    }

    @Override
    public void onAssetAdded(UUID assetUUID) {
        for (GSIAssetStorageListener listener : this.listeners) {
            listener.onAssetAdded(assetUUID);
        }
    }

    @Override
    public void onAssetRemoved(UUID assetUUID) {
        for (GSIAssetStorageListener listener : this.listeners) {
            listener.onAssetRemoved(assetUUID);
        }
    }

    private static class GSCombinedAssetHistory
    implements GSIAssetHistory,
    GSIAssetHistoryListener {
        private final GSIAssetHistory[] histories;
        private final List<GSIAssetHistoryListener> listeners;

        public GSCombinedAssetHistory(GSAssetStorage[] storages) {
            this.histories = new GSIAssetHistory[storages.length];
            for (int i = 0; i < storages.length; ++i) {
                GSIAssetHistory history;
                this.histories[i] = history = storages[i].getStoredHistory();
                history.addListener(this);
            }
            this.listeners = new ArrayList<GSIAssetHistoryListener>();
        }

        @Override
        public void addListener(GSIAssetHistoryListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener is null!");
            }
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(GSIAssetHistoryListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public boolean contains(UUID assetUUID) {
            for (GSIAssetHistory history : this.histories) {
                if (!history.contains(assetUUID)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsHandle(GSAssetHandle handle) {
            return this.histories[handle.getNamespace().getIndex()].containsHandle(handle);
        }

        @Override
        public GSAssetInfo get(UUID assetUUID) {
            for (GSIAssetHistory history : this.histories) {
                GSAssetInfo info = history.get(assetUUID);
                if (info == null) continue;
                return info;
            }
            return null;
        }

        @Override
        public GSAssetInfo getFromHandle(GSAssetHandle handle) {
            return this.histories[handle.getNamespace().getIndex()].getFromHandle(handle);
        }

        @Override
        public void add(GSAssetInfo info) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(Iterable<GSAssetInfo> iterable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GSAssetInfo remove(UUID assetUUID) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(GSIAssetHistory other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            int s = 0;
            for (GSIAssetHistory history : this.histories) {
                s += history.size();
            }
            return s;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Collection<GSAssetInfo> asCollection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<GSAssetInfo> iterator() {
            return Iterables.concat((Iterable[])this.histories).iterator();
        }

        @Override
        public void onHistoryChanged(UUID assetUUID) {
            for (GSIAssetHistoryListener listener : this.listeners) {
                listener.onHistoryChanged(assetUUID);
            }
        }
    }

    private static class GSCombinedPlayerCache
    extends GSAbstractPlayerCache
    implements GSIPlayerCacheListener {
        private final GSIPlayerCache[] caches;

        public GSCombinedPlayerCache(GSAssetStorage[] storages) {
            this.caches = new GSIPlayerCache[storages.length];
            for (int i = 0; i < storages.length; ++i) {
                GSIPlayerCache cache;
                this.caches[i] = cache = storages[i].getPlayerCache();
                cache.addListener(this);
            }
        }

        @Override
        public GSPlayerCacheEntry get(UUID playerUUID) {
            for (GSIPlayerCache cache : this.caches) {
                GSPlayerCacheEntry entry = cache.get(playerUUID);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }

        @Override
        public Iterable<UUID> getPlayers() {
            return () -> new GSCombinedPlayerCacheIterator(this.caches);
        }

        @Override
        public void onEntryAdded(UUID playerUUID) {
            if (playerUUID == null || this.getEntryCount(playerUUID) == 1) {
                this.dispatchEntryAdded(playerUUID);
            }
        }

        @Override
        public void onEntryRemoved(UUID playerUUID) {
            if (this.getEntryCount(playerUUID) == 0) {
                this.dispatchEntryRemoved(playerUUID);
            }
        }

        private int getEntryCount(UUID playerUUID) {
            int cnt = 0;
            for (GSIPlayerCache cache : this.caches) {
                if (cache.get(playerUUID) == null) continue;
                ++cnt;
            }
            return cnt;
        }
    }

    private static class GSCombinedPlayerCacheIterator
    implements Iterator<UUID> {
        private final GSIPlayerCache[] caches;
        private int cur;
        private Iterator<UUID> itr;
        private UUID nextElem;

        public GSCombinedPlayerCacheIterator(GSIPlayerCache[] caches) {
            this.caches = caches;
            this.cur = 0;
            this.prepareCurIter();
        }

        private void prepareCurIter() {
            this.itr = this.cur < this.caches.length ? this.caches[this.cur].getPlayers().iterator() : null;
        }

        private void prepareNext() {
            while (this.itr != null && !this.itr.hasNext()) {
                ++this.cur;
                this.prepareCurIter();
            }
            this.nextElem = this.itr != null ? this.itr.next() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextElem != null) {
                return true;
            }
            do {
                this.prepareNext();
                if (this.nextElem != null) continue;
                return false;
            } while (this.isElementSeen(this.nextElem));
            return true;
        }

        private boolean isElementSeen(UUID elem) {
            for (int i = 0; i < this.cur; ++i) {
                if (this.caches[i].get(elem) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public UUID next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            UUID elem = this.nextElem;
            this.nextElem = null;
            return elem;
        }
    }
}

