/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

public enum GSEAssetType {
    COMPOSITION("composition", true, 0),
    SEQUENCE("sequence", true, 1);

    private static final GSEAssetType[] TYPES;
    private final String name;
    private final boolean streamable;
    private final int index;

    private GSEAssetType(String name, boolean streamable, int index) {
        this.name = name;
        this.streamable = streamable;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public int getIndex() {
        return this.index;
    }

    public static GSEAssetType fromIndex(int index) {
        if (index < 0 || index >= TYPES.length) {
            return null;
        }
        return TYPES[index];
    }

    static {
        TYPES = new GSEAssetType[GSEAssetType.values().length];
        GSEAssetType[] gSEAssetTypeArray = GSEAssetType.values();
        int n = gSEAssetTypeArray.length;
        for (int i = 0; i < n; ++i) {
            GSEAssetType type;
            GSEAssetType.TYPES[type.index] = type = gSEAssetTypeArray[i];
        }
    }
}

