/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition;

import com.g4mesoft.captureplayback.common.GSCaptureStream;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSSequence;

class GSCompositionCaptureStream
extends GSCaptureStream {
    public GSCompositionCaptureStream(GSComposition composition) {
        super(composition.getBlockRegion());
        for (GSTrack track : composition.getTracks()) {
            long smallestOffset = Long.MAX_VALUE;
            for (GSTrackEntry entry : track.getEntries()) {
                if (entry.getOffset() >= smallestOffset) continue;
                smallestOffset = entry.getOffset();
            }
            if (smallestOffset == Long.MAX_VALUE) continue;
            GSSequence sequence = track.getSequence();
            for (GSChannel channel : sequence.getChannels()) {
                this.addChannelCapture(channel, smallestOffset);
            }
        }
    }
}

