/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition;

import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.util.GSUUIDUtil;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GSTrack {
    private final UUID trackUUID;
    private String name;
    private int color;
    private UUID groupUUID;
    private final GSSequence sequence;
    private final Map<UUID, GSTrackEntry> entries;
    private GSComposition parent;

    GSTrack(GSTrack other) {
        this.trackUUID = other.getTrackUUID();
        this.name = other.getName();
        this.color = other.getColor();
        this.groupUUID = other.getGroupUUID();
        this.sequence = new GSSequence(other.getSequence());
        this.entries = new LinkedHashMap<UUID, GSTrackEntry>();
        for (GSTrackEntry entry : other.getEntries()) {
            this.addEntryInternal(new GSTrackEntry(entry));
        }
    }

    GSTrack(UUID trackUUID, String name, int color, UUID groupUUID) {
        this(trackUUID, name, color, groupUUID, new GSSequence(trackUUID));
    }

    private GSTrack(UUID trackUUID, String name, int color, UUID groupUUID, GSSequence sequence) {
        if (trackUUID == null) {
            throw new IllegalArgumentException("trackUUID is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (groupUUID == null) {
            throw new IllegalArgumentException("groupUUID is null");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("sequence is null");
        }
        this.trackUUID = trackUUID;
        this.name = name;
        this.color = color | 0xFF000000;
        this.groupUUID = groupUUID;
        this.sequence = sequence;
        this.entries = new LinkedHashMap<UUID, GSTrackEntry>();
        this.parent = null;
    }

    public GSComposition getParent() {
        return this.parent;
    }

    void onAdded(GSComposition parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Track already has a parent");
        }
        this.parent = parent;
        GSTrackGroup group = this.getGroup();
        if (group != null) {
            group.addTrack(this.trackUUID);
        }
    }

    void onRemoved(GSComposition parent) {
        if (this.parent != parent) {
            throw new IllegalStateException("Track does not have the specified parent");
        }
        GSTrackGroup group = this.getGroup();
        if (group != null) {
            group.removeTrack(this.trackUUID);
        }
        this.parent = null;
    }

    void duplicateFrom(GSTrack other) {
        this.clear();
        this.setName(other.getName());
        this.setColor(other.getColor());
        this.sequence.duplicateFrom(other.getSequence());
        this.sequence.setName(other.getSequence().getName());
        for (GSTrackEntry entry : other.getEntries()) {
            this.addEntry(entry.getOffset()).duplicateFrom(entry);
        }
    }

    void set(GSTrack other) {
        this.clear();
        this.setName(other.getName());
        this.setColor(other.getColor());
        this.setGroupUUID(other.getGroupUUID());
        this.sequence.set(other.getSequence());
        for (GSTrackEntry entry : other.getEntries()) {
            this.addEntry(entry.getEntryUUID(), entry.getOffset()).set(entry);
        }
    }

    private void clear() {
        Iterator<GSTrackEntry> itr = this.entries.values().iterator();
        while (itr.hasNext()) {
            GSTrackEntry entry = itr.next();
            itr.remove();
            this.onEntryRemoved(entry);
        }
    }

    public GSTrackEntry addEntry(long offset) {
        return this.addEntry(GSUUIDUtil.randomUnique(this::hasEntryUUID), offset);
    }

    public GSTrackEntry addEntry(UUID entryUUID, long offset) {
        if (this.hasEntryUUID(entryUUID)) {
            throw new IllegalStateException("Duplicate entry UUID");
        }
        GSTrackEntry entry = new GSTrackEntry(entryUUID, offset);
        this.addEntryInternal(entry);
        this.dispatchEntryAdded(entry);
        return entry;
    }

    private void addEntryInternal(GSTrackEntry entry) {
        entry.onAdded(this);
        this.entries.put(entry.getEntryUUID(), entry);
    }

    public boolean removeEntry(UUID entryUUID) {
        GSTrackEntry entry = this.entries.remove(entryUUID);
        if (entry != null) {
            this.onEntryRemoved(entry);
            return true;
        }
        return false;
    }

    private void onEntryRemoved(GSTrackEntry entry) {
        this.dispatchEntryRemoved(entry);
        entry.onRemoved(this);
    }

    public UUID getTrackUUID() {
        return this.trackUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.dispatchTrackNameChanged(oldName);
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        if ((color |= 0xFF000000) != this.color) {
            int oldColor = this.color;
            this.color = color;
            this.dispatchTrackColorChanged(oldColor);
        }
    }

    public UUID getGroupUUID() {
        return this.groupUUID;
    }

    public void setGroupUUID(UUID groupUUID) {
        if (this.parent == null || !this.parent.hasGroupUUID(groupUUID)) {
            throw new IllegalArgumentException("Group does not exist");
        }
        if (!groupUUID.equals(this.groupUUID)) {
            UUID oldGroupUUID = this.groupUUID;
            this.getGroup().removeTrack(this.trackUUID);
            this.groupUUID = groupUUID;
            this.getGroup().addTrack(this.trackUUID);
            this.dispatchGroupChanged(oldGroupUUID);
        }
    }

    public GSTrackGroup getGroup() {
        if (this.parent == null) {
            throw new IllegalStateException("Track not added");
        }
        return this.parent.getGroup(this.groupUUID);
    }

    public GSSequence getSequence() {
        return this.sequence;
    }

    public GSTrackEntry getEntry(UUID entryUUID) {
        return this.entries.get(entryUUID);
    }

    public boolean hasEntryUUID(UUID entryUUID) {
        return this.entries.containsKey(entryUUID);
    }

    public Set<UUID> getEntryUUIDs() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public Collection<GSTrackEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    private void dispatchTrackNameChanged(String oldName) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.trackNameChanged(this, oldName);
            }
        }
    }

    private void dispatchTrackColorChanged(int oldColor) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.trackColorChanged(this, oldColor);
            }
        }
    }

    private void dispatchGroupChanged(UUID oldGroup) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.trackGroupChanged(this, oldGroup);
            }
        }
    }

    private void dispatchEntryAdded(GSTrackEntry entry) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.entryAdded(entry);
            }
        }
    }

    private void dispatchEntryRemoved(GSTrackEntry entry) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.entryRemoved(entry);
            }
        }
    }

    public static GSTrack read(GSDecodeBuffer buf) throws IOException {
        UUID trackUUID = buf.readUUID();
        String name = buf.readString();
        int color = buf.readMedium();
        UUID groupUUID = buf.readUUID();
        GSSequence sequence = GSSequence.read(buf);
        GSTrack track = new GSTrack(trackUUID, name, color, groupUUID, sequence);
        int entryCount = buf.readInt();
        while (entryCount-- != 0) {
            GSTrackEntry entry = GSTrackEntry.read(buf);
            if (track.hasEntryUUID(entry.getEntryUUID())) {
                throw new IOException("Duplicate entry UUID");
            }
            track.addEntryInternal(entry);
        }
        return track;
    }

    public static void write(GSEncodeBuffer buf, GSTrack track) throws IOException {
        buf.writeUUID(track.getTrackUUID());
        buf.writeString(track.getName());
        buf.writeMedium(track.getColor());
        buf.writeUUID(track.getGroupUUID());
        GSSequence.write(buf, track.getSequence());
        Collection<GSTrackEntry> entries = track.getEntries();
        buf.writeInt(entries.size());
        for (GSTrackEntry entry : entries) {
            GSTrackEntry.write(buf, entry);
        }
    }
}

