/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackColorDelta
extends GSTrackDelta {
    private int newColor;
    private int oldColor;

    public GSTrackColorDelta() {
    }

    public GSTrackColorDelta(UUID trackUUID, int newColor, int oldColor) {
        super(trackUUID);
        this.newColor = newColor;
        this.oldColor = oldColor;
    }

    private void setTrackColor(GSComposition composition, int newColor, int oldColor) throws GSDeltaException {
        GSTrack track = this.getTrack(composition);
        this.checkTrackColor(track, oldColor);
        track.setColor(newColor);
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.setTrackColor(composition, this.oldColor, this.newColor);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.setTrackColor(composition, this.newColor, this.oldColor);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newColor = buf.readInt();
        this.oldColor = buf.readInt();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeInt(this.newColor);
        buf.writeInt(this.oldColor);
    }
}

