/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public abstract class GSTrackDelta
implements GSIDelta<GSComposition> {
    protected UUID trackUUID;

    protected GSTrackDelta() {
    }

    protected GSTrackDelta(UUID trackUUID) {
        this.trackUUID = trackUUID;
    }

    protected GSTrack getTrack(GSComposition composition) throws GSDeltaException {
        GSTrack track = composition.getTrack(this.trackUUID);
        if (track == null) {
            throw new GSDeltaException("Expected track does not exist");
        }
        return track;
    }

    protected void checkTrackName(GSTrack track, String expectedName) throws GSDeltaException {
        if (!track.getName().equals(expectedName)) {
            throw new GSDeltaException("Track does not have the expected name");
        }
    }

    protected void checkTrackColor(GSTrack track, int expectedColor) throws GSDeltaException {
        if (track.getColor() != expectedColor) {
            throw new GSDeltaException("Track does not have the expected color");
        }
    }

    protected void checkGroup(GSTrack track, UUID expectedGroupUUID) throws GSDeltaException {
        if (!track.getGroupUUID().equals(expectedGroupUUID)) {
            throw new GSDeltaException("Track is not in the expected group");
        }
    }

    protected void checkSequenceChannelCount(GSTrack track, int expectedCount) throws GSDeltaException {
        if (track.getSequence().getChannels().size() != expectedCount) {
            throw new GSDeltaException("Track sequence does not have the expected channel count");
        }
    }

    protected void checkSequenceEntryCount(GSTrack track, int expectedCount) throws GSDeltaException {
        if (this.getSequenceEntryCount(track.getSequence()) != expectedCount) {
            throw new GSDeltaException("Track sequence does not have the expected entry count");
        }
    }

    protected void checkTrackEntryCount(GSTrack track, int expectedCount) throws GSDeltaException {
        if (track.getEntries().size() != expectedCount) {
            throw new GSDeltaException("Track does not have the expected entry count");
        }
    }

    protected int getSequenceEntryCount(GSSequence sequence) {
        int count = 0;
        for (GSChannel channel : sequence.getChannels()) {
            count += channel.getEntries().size();
        }
        return count;
    }

    protected void removeTrack(GSComposition composition, String name, int color, UUID groupUUID, int expectedSequenceChannelCount, int expectedSequenceEntryCount, int expectedEntryCount) throws GSDeltaException {
        GSTrack track = this.getTrack(composition);
        this.checkTrackName(track, name);
        this.checkTrackColor(track, color);
        this.checkGroup(track, groupUUID);
        this.checkSequenceChannelCount(track, expectedSequenceChannelCount);
        this.checkSequenceEntryCount(track, expectedSequenceEntryCount);
        this.checkTrackEntryCount(track, expectedEntryCount);
        composition.removeTrack(this.trackUUID);
    }

    protected GSTrack addTrack(GSComposition composition, String name, int color, UUID groupUUID) throws GSDeltaException {
        if (composition.hasTrackUUID(this.trackUUID)) {
            throw new GSDeltaException("Track already exists");
        }
        if (!composition.hasGroupUUID(groupUUID)) {
            throw new GSDeltaException("Track group does not exist");
        }
        try {
            return composition.addTrack(this.trackUUID, name, color, groupUUID);
        }
        catch (Throwable t) {
            composition.removeTrack(this.trackUUID);
            throw new GSDeltaException("Failed to add track", t);
        }
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.trackUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUUID(this.trackUUID);
    }
}

