/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackEntryAddedDelta
extends GSTrackEntryDelta {
    private long offset;

    public GSTrackEntryAddedDelta() {
    }

    public GSTrackEntryAddedDelta(GSTrackEntry entry) {
        this(entry.getParent().getTrackUUID(), entry.getEntryUUID(), entry.getOffset());
    }

    public GSTrackEntryAddedDelta(UUID channelUUID, UUID entryUUID, long offset) {
        super(channelUUID, entryUUID);
        this.offset = offset;
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.removeEntry(composition, this.offset);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.addEntry(composition, this.offset);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.offset = buf.readLong();
        if (this.offset < 0L) {
            throw new IOException("Invalid offset");
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeLong(this.offset);
    }
}

