/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackNameDelta
extends GSTrackDelta {
    private String newName;
    private String oldName;

    public GSTrackNameDelta() {
    }

    public GSTrackNameDelta(UUID trackUUID, String newName, String oldName) {
        super(trackUUID);
        this.newName = newName;
        this.oldName = oldName;
    }

    private void setTrackName(GSComposition composition, String newName, String oldName) throws GSDeltaException {
        GSTrack track = this.getTrack(composition);
        this.checkTrackName(track, oldName);
        track.setName(newName);
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.setTrackName(composition, this.oldName, this.newName);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.setTrackName(composition, this.newName, this.oldName);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newName = buf.readString();
        this.oldName = buf.readString();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeString(this.newName);
        buf.writeString(this.oldName);
    }
}

