/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.client;

import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.gui.GSDefaultChannelProvider;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.captureplayback.module.client.GSSequencePositionRenderable;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSISessionListener;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.core.client.GSIClientModule;
import com.g4mesoft.core.client.GSIClientModuleManager;
import com.g4mesoft.gui.GSTabbedGUI;
import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSKeyManager;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.types.GSIntegerSetting;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.renderer.GSIRenderable3D;
import com.g4mesoft.ui.util.GSColorUtil;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;

@Environment(value=EnvType.CLIENT)
public class GSCapturePlaybackClientModule
implements GSIClientModule,
GSISessionListener {
    public static final int RENDERING_DISABLED = 0;
    public static final int RENDERING_DEPTH = 1;
    public static final int RENDERING_NO_DEPTH = 2;
    private static final String GUI_TAB_TITLE = "gui.tab.capture-playback";
    public static final String KEY_CATEGORY = "capture-playback";
    public static final GSSettingCategory CAPTURE_PLAYBACK_CATEGORY = new GSSettingCategory("capture-playback");
    private GSClientAssetManager assetManager = null;
    private final GSDefaultChannelProvider channelProvider = new GSDefaultChannelProvider();
    public final GSIntegerSetting cChannelRenderingType = new GSIntegerSetting("channelRenderingType", 0, 0, 2);

    public void init(GSIClientModuleManager manager) {
        this.assetManager = new GSClientAssetManager(manager);
        manager.addRenderable((GSIRenderable3D)new GSSequencePositionRenderable(this));
    }

    public void onClose() {
        this.assetManager = null;
    }

    public void initGUI(GSTabbedGUI tabbedGUI) {
        tabbedGUI.addTab(GUI_TAB_TITLE, (GSPanel)new GSScrollPanel((GSPanel)new GSCapturePlaybackPanel(this.assetManager)));
    }

    public void registerHotkeys(GSKeyManager keyManager) {
        keyManager.registerKey("channelRenderingType", KEY_CATEGORY, -1, () -> ((GSIntegerSetting)this.cChannelRenderingType).increment(), GSEKeyEventType.PRESS);
        keyManager.registerKey("newChannel", KEY_CATEGORY, -1, this::createNewChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("extendChannel", KEY_CATEGORY, -1, this::extendChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("unextendChannel", KEY_CATEGORY, -1, this::unextendChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("selectChannel", KEY_CATEGORY, -1, () -> {
            GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
            GSChannel channel = this.getChannelAtCrosshair(session);
            if (channel != null && session != null) {
                session.set(GSSession.SELECTED_CHANNEL, channel.getChannelUUID());
            }
        }, GSEKeyEventType.PRESS);
        keyManager.registerKey("pasteChannelColor", KEY_CATEGORY, -1, channel -> {
            GSSequence sequence;
            GSChannel selectedChannel;
            GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
            if (session != null && (selectedChannel = (sequence = session.get(GSSession.SEQUENCE)).getChannel(session.get(GSSession.SELECTED_CHANNEL))) != null) {
                return channel.getInfo().withColor(selectedChannel.getInfo().getColor());
            }
            return channel.getInfo();
        }, this::modifyCrosshairChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("brightenChannelColor", KEY_CATEGORY, -1, channel -> channel.getInfo().withColor(GSColorUtil.brighter((int)channel.getInfo().getColor())), this::modifyCrosshairChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("darkenChannelColor", KEY_CATEGORY, -1, channel -> channel.getInfo().withColor(GSColorUtil.darker((int)channel.getInfo().getColor())), this::modifyCrosshairChannel, GSEKeyEventType.PRESS);
        keyManager.registerKey("randomizeChannelColor", KEY_CATEGORY, -1, channel -> channel.getInfo().withColor(GSDefaultChannelProvider.getUniqueColor(channel.getParent())), this::modifyCrosshairChannel, GSEKeyEventType.PRESS);
    }

    private void createNewChannel() {
        GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
        if (session != null) {
            GSChannelInfo info;
            GSChannel channel;
            GSSequence sequence = session.get(GSSession.SEQUENCE);
            class_2338 position = GSCapturePlaybackClientModule.getCrosshairTarget();
            if (position != null && (channel = sequence.addChannel(info = this.channelProvider.createChannelInfo(sequence, position))) != null && session != null) {
                session.set(GSSession.SELECTED_CHANNEL, channel.getChannelUUID());
            }
        }
    }

    private void extendChannel() {
        GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
        if (session != null) {
            GSSequence sequence = session.get(GSSession.SEQUENCE);
            class_2338 position = GSCapturePlaybackClientModule.getCrosshairTarget();
            GSChannel channel = sequence.getChannel(session.get(GSSession.SELECTED_CHANNEL));
            if (position != null && channel != null) {
                channel.setInfo(channel.getInfo().addPosition(position));
            }
        }
    }

    private void unextendChannel() {
        GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
        if (session != null) {
            GSChannelInfo info;
            GSSequence sequence = session.get(GSSession.SEQUENCE);
            class_2338 position = GSCapturePlaybackClientModule.getCrosshairTarget();
            GSChannel channel = sequence.getChannel(session.get(GSSession.SELECTED_CHANNEL));
            if (position != null && channel != null && (info = channel.getInfo()).getPositions().size() > 1) {
                channel.setInfo(info.removePosition(position));
            }
        }
    }

    private GSChannel getChannelAtCrosshair(GSSession session) {
        if (session != null && session.getType() == GSESessionType.SEQUENCE) {
            GSSequence sequence = session.get(GSSession.SEQUENCE);
            class_2338 position = GSCapturePlaybackClientModule.getCrosshairTarget();
            if (position != null) {
                for (GSChannel channel : sequence.getChannels()) {
                    if (!channel.getInfo().getPositions().contains(position)) continue;
                    return channel;
                }
            }
        }
        return null;
    }

    private void modifyCrosshairChannel(Function<GSChannel, GSChannelInfo> modifier) {
        GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
        GSChannel channel = this.getChannelAtCrosshair(session);
        if (channel != null) {
            channel.setInfo(modifier.apply(channel));
        }
    }

    public static class_2338 getCrosshairTarget() {
        class_310 client = class_310.method_1551();
        if (client.field_1765 == null) {
            return null;
        }
        if (client.field_1765.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        return ((class_3965)client.field_1765).method_17777();
    }

    public void registerClientSettings(GSSettingManager settings) {
        settings.registerSetting(CAPTURE_PLAYBACK_CATEGORY, (GSSetting)this.cChannelRenderingType);
    }

    public void onDisconnectServer() {
        this.assetManager.onDisconnect();
    }

    public GSClientAssetManager getAssetManager() {
        return this.assetManager;
    }
}

