/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSIAssetStorageListener;
import com.g4mesoft.captureplayback.module.server.GSISessionStatusListener;
import com.g4mesoft.captureplayback.module.server.GSSessionTracker;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.core.server.GSIServerModuleManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;

public class GSSessionManager
implements GSIAssetStorageListener {
    private final GSIServerModuleManager manager;
    private final GSAssetManager assetManager;
    private final File cacheDir;
    private final Map<UUID, GSSessionTracker> trackers;
    private final Map<UUID, Set<UUID>> playerToAssets;
    private final GSSessionTrackerListener trackerListener;
    private final List<GSISessionStatusListener> listeners;

    public GSSessionManager(GSIServerModuleManager manager, GSAssetManager assetManager, File cacheDir) {
        this.manager = manager;
        this.assetManager = assetManager;
        this.cacheDir = cacheDir;
        this.trackers = new HashMap<UUID, GSSessionTracker>();
        this.playerToAssets = new HashMap<UUID, Set<UUID>>();
        this.trackerListener = new GSSessionTrackerListener();
        this.listeners = new ArrayList<GSISessionStatusListener>();
    }

    public void init() {
        this.assetManager.addListener(this);
    }

    public void dispose() {
        this.stopAll();
        this.assetManager.removeListener(this);
    }

    public boolean onRequest(class_3222 player, GSESessionRequestType requestType, UUID assetUUID) {
        GSSessionTracker tracker;
        if (this.assetManager.hasPermission(player, assetUUID) && (tracker = this.getTracker(assetUUID)) != null && tracker.onRequest(player, requestType)) {
            if (requestType == GSESessionRequestType.REQUEST_STOP && tracker.isEmpty()) {
                this.trackers.remove(assetUUID);
                tracker.getRef().release();
                this.onTrackerRemoved(tracker);
            }
            return true;
        }
        return false;
    }

    private GSSessionTracker getTracker(UUID assetUUID) {
        GSSessionTracker tracker = this.trackers.get(assetUUID);
        if (tracker == null) {
            GSAssetRef ref = this.assetManager.requestAsset(assetUUID);
            GSAssetInfo info = this.assetManager.getInfo(assetUUID);
            if (info != null && ref != null) {
                tracker = new GSSessionTracker(this.manager, info, ref, this.getCacheDir(assetUUID));
                this.trackers.put(assetUUID, tracker);
                this.onTrackerAdded(tracker);
            }
        }
        return tracker;
    }

    public void stopAll(class_3222 player) {
        Set<UUID> assetUUIDs = this.playerToAssets.get(player.method_5667());
        if (assetUUIDs != null) {
            UUID[] assetUUIDArray;
            for (UUID assetUUID : assetUUIDArray = assetUUIDs.toArray(new UUID[0])) {
                this.onRequest(player, GSESessionRequestType.REQUEST_STOP, assetUUID);
            }
        }
    }

    public void stopAll() {
        for (GSSessionTracker tracker : this.trackers.values()) {
            tracker.stopAll();
            this.onTrackerRemoved(tracker);
        }
        this.trackers.clear();
    }

    public Iterator<GSSession> iterateSessions(class_3222 player) {
        return new GSPlayerSessionIterator(player);
    }

    private void onTrackerAdded(GSSessionTracker tracker) {
        tracker.setListener(this.trackerListener);
    }

    private void onTrackerRemoved(GSSessionTracker tracker) {
        tracker.setListener(null);
    }

    public void onDeltasReceived(class_3222 player, UUID assetUUID, GSIDelta<GSSession>[] deltas) {
        GSSessionTracker tracker = this.trackers.get(assetUUID);
        if (tracker != null) {
            tracker.onDeltasReceived(player, deltas);
        }
    }

    private File getCacheDir(UUID assetUUID) {
        return new File(this.cacheDir, assetUUID.toString());
    }

    public void addListener(GSISessionStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public void removeListener(GSISessionStatusListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatchSessionStarted(class_3222 player, UUID assetUUID) {
        for (GSISessionStatusListener listener : this.listeners) {
            listener.sessionStarted(player, assetUUID);
        }
    }

    private void dispatchSessionStopped(class_3222 player, UUID assetUUID) {
        for (GSISessionStatusListener listener : this.listeners) {
            listener.sessionStopped(player, assetUUID);
        }
    }

    @Override
    public void onAssetAdded(UUID assetUUID) {
    }

    @Override
    public void onAssetRemoved(UUID assetUUID) {
        GSSessionTracker tracker = this.trackers.remove(assetUUID);
        if (tracker != null) {
            tracker.stopAll();
            this.onTrackerRemoved(tracker);
        }
    }

    private class GSSessionTrackerListener
    implements GSISessionStatusListener {
        private GSSessionTrackerListener() {
        }

        @Override
        public void sessionStarted(class_3222 player, UUID assetUUID) {
            Set<UUID> assetUUIDs = GSSessionManager.this.playerToAssets.get(player.method_5667());
            if (assetUUIDs == null) {
                assetUUIDs = new LinkedHashSet<UUID>();
                GSSessionManager.this.playerToAssets.put(player.method_5667(), assetUUIDs);
            }
            if (assetUUIDs.add(assetUUID)) {
                GSSessionManager.this.dispatchSessionStarted(player, assetUUID);
            }
        }

        @Override
        public void sessionStopped(class_3222 player, UUID assetUUID) {
            Set<UUID> assetUUIDs = GSSessionManager.this.playerToAssets.get(player.method_5667());
            if (assetUUIDs != null && assetUUIDs.remove(assetUUID)) {
                if (assetUUIDs.isEmpty()) {
                    GSSessionManager.this.playerToAssets.remove(player.method_5667());
                }
                GSSessionManager.this.dispatchSessionStopped(player, assetUUID);
            }
        }
    }

    private class GSPlayerSessionIterator
    implements Iterator<GSSession> {
        private final class_3222 player;
        private final Iterator<UUID> itr;

        public GSPlayerSessionIterator(class_3222 player) {
            this.player = player;
            Set<UUID> assetUUIDs = GSSessionManager.this.playerToAssets.get(player.method_5667());
            this.itr = assetUUIDs != null ? assetUUIDs.iterator() : Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public GSSession next() {
            GSSessionTracker tracker = GSSessionManager.this.trackers.get(this.itr.next());
            if (tracker == null) {
                throw new ConcurrentModificationException();
            }
            GSSession session = tracker.getSession(this.player);
            if (session == null) {
                throw new ConcurrentModificationException();
            }
            return session;
        }
    }
}

