/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel;

public enum GSEContentOpacity {
    OPACITY_25(0, "panel.opacity25", 0.25f),
    OPACITY_50(1, "panel.opacity50", 0.5f),
    OPACITY_75(2, "panel.opacity75", 0.75f),
    OPACITY_90(3, "panel.opacity90", 0.9f),
    FULLY_OPAQUE(4, "panel.opacity100", 1.0f);

    public static final GSEContentOpacity[] OPACITIES;
    private final int index;
    private final String name;
    private final float opacity;

    private GSEContentOpacity(int index, String name, float opacity) {
        this.index = index;
        this.name = name;
        this.opacity = opacity;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public static GSEContentOpacity fromIndex(int index) {
        if (index < 0 || index >= OPACITIES.length) {
            return null;
        }
        return OPACITIES[index];
    }

    static {
        OPACITIES = new GSEContentOpacity[GSEContentOpacity.values().length];
        for (GSEContentOpacity opacity : GSEContentOpacity.values()) {
            if (OPACITIES[opacity.index] != null) {
                throw new ExceptionInInitializerError("Duplicate opacity index");
            }
            GSEContentOpacity.OPACITIES[opacity.index] = opacity;
        }
    }
}

