/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.composition;

import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionModelView;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;

public class GSCompositionColumnHeaderPanel
extends GSPanel
implements GSIScrollable,
GSIModelViewListener {
    private static final int COLUMN_HEADER_PREFERRED_HEIGHT = 12;
    public static final int BACKGROUND_COLOR = -14540254;
    public static final int TIME_INDICATOR_COLOR = -8947849;
    private final GSCompositionModelView modelView;

    public GSCompositionColumnHeaderPanel(GSCompositionModelView modelView) {
        this.modelView = modelView;
    }

    protected void onShown() {
        super.onShown();
        this.modelView.addModelViewListener(this);
    }

    protected void onHidden() {
        super.onHidden();
        this.modelView.removeModelViewListener(this);
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        GSRectangle bounds = renderer.getClipBounds().intersection(0, 0, this.width, this.height);
        this.renderBackground(renderer, bounds);
        this.renderTimeIndicators(renderer, bounds);
    }

    private void renderBackground(GSIRenderer2D renderer, GSRectangle bounds) {
        renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, -14540254);
    }

    private void renderTimeIndicators(GSIRenderer2D renderer, GSRectangle bounds) {
        long interval = this.modelView.getTimeIndicatorInterval();
        long gt = this.modelView.getTimeIndicatorFromX(bounds.x);
        int x = this.modelView.getGametickX(gt);
        while (x - bounds.x < bounds.width) {
            renderer.drawTextNoStyle((CharSequence)Long.toString(gt), x + 3, 2, -8947849);
            x = this.modelView.getGametickX(gt += interval);
        }
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(this.modelView.getMinimumWidth(), 12);
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    @Override
    public void modelViewChanged() {
        this.invalidate();
    }
}

