/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.composition;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GSCompositionModelView
implements GSICompositionListener,
GSISequenceListener {
    private static final int TRACK_HEIGHT = 50;
    private static final int TRACK_SPACING = 1;
    private static final int MINIMUM_SEQUENCE_DURATION = 1;
    private static final double DEFAULT_GAMETICK_WIDTH = 8.0;
    private static final double MIN_GAMETICK_WIDTH = 0.01;
    private static final double MAX_GAMETICK_WIDTH = 75.0;
    private static final int MIN_TIME_INDICATOR_WIDTH = 75;
    public static final long TIME_SUB_INDICATOR_COUNT = 5L;
    private final GSComposition model;
    private final Map<UUID, Integer> trackUUIDToIndex;
    private final Map<Integer, UUID> trackIndexToUUID;
    private final Map<UUID, Long> sequenceDurations;
    private long minimumGametickCount;
    private long timeIndicatorInterval;
    private double gametickWidth;
    private final List<GSIModelViewListener> listenters;

    public GSCompositionModelView(GSComposition model) {
        this.model = model;
        this.trackUUIDToIndex = new HashMap<UUID, Integer>();
        this.trackIndexToUUID = new HashMap<Integer, UUID>();
        this.sequenceDurations = new HashMap<UUID, Long>();
        this.minimumGametickCount = 0L;
        this.timeIndicatorInterval = 1L;
        this.gametickWidth = 8.0;
        this.listenters = new ArrayList<GSIModelViewListener>();
        this.calculateTimeIndicatorInterval();
    }

    public void installListeners() {
        this.model.addCompositionListener(this);
        for (GSTrack track : this.model.getTracks()) {
            track.getSequence().addSequenceListener(this);
        }
    }

    public void uninstallListeners() {
        this.model.removeCompositionListener(this);
        for (GSTrack track : this.model.getTracks()) {
            track.getSequence().removeSequenceListener(this);
        }
    }

    public void updateModelView() {
        this.updateTrackIndexLookup();
        this.updateAllSequenceDurations();
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    private void updateTrackIndexLookup() {
        this.trackUUIDToIndex.clear();
        this.trackIndexToUUID.clear();
        int trackIndex = 0;
        for (UUID trackUUID : this.model.getTrackUUIDs()) {
            this.trackUUIDToIndex.put(trackUUID, trackIndex);
            this.trackIndexToUUID.put(trackIndex, trackUUID);
            ++trackIndex;
        }
    }

    private void updateAllSequenceDurations() {
        for (GSTrack track : this.model.getTracks()) {
            this.updateSequenceDuration(track.getSequence());
        }
    }

    private void updateSequenceDuration(GSSequence sequence) {
        GSSignalTime latestTime = GSSignalTime.ZERO;
        for (GSChannel channel : sequence.getChannels()) {
            for (GSChannelEntry entry : channel.getEntries()) {
                if (!entry.getEndTime().isAfter(latestTime)) continue;
                latestTime = entry.getEndTime();
            }
        }
        long duration = latestTime.getGametick() + 1L;
        if (duration < 1L) {
            duration = 1L;
        }
        this.sequenceDurations.put(sequence.getSequenceUUID(), duration);
    }

    private void updateMinimumGametickCount() {
        this.minimumGametickCount = 0L;
        for (GSTrack track : this.model.getTracks()) {
            long duration = this.getSequenceDuration(track.getSequence());
            for (GSTrackEntry entry : track.getEntries()) {
                if (entry.getOffset() + duration <= this.minimumGametickCount) continue;
                this.minimumGametickCount = entry.getOffset() + duration;
            }
        }
    }

    public long getSequenceDuration(GSSequence sequence) {
        return this.getSequenceDuration(sequence.getSequenceUUID());
    }

    public long getSequenceDuration(UUID sequenceUUID) {
        Long duration = this.sequenceDurations.get(sequenceUUID);
        return duration != null ? duration : -1L;
    }

    public boolean isTrackAfter(GSTrack track, GSTrack otherTrack) {
        return this.isTrackAfter(track.getTrackUUID(), otherTrack.getTrackUUID());
    }

    public boolean isTrackAfter(UUID trackUUID, UUID otherTrackUUID) {
        Integer i0 = this.trackUUIDToIndex.get(trackUUID);
        Integer i1 = this.trackUUIDToIndex.get(otherTrackUUID);
        if (i0 == null || i1 == null) {
            return i0 == null;
        }
        return i0 > i1;
    }

    public GSTrack getNextTrack(GSTrack track, boolean descending) {
        return this.getNextTrack(track, descending, true);
    }

    public UUID getNextTrack(UUID trackUUID, boolean descending) {
        return this.getNextTrack(trackUUID, descending, true);
    }

    public GSTrack getNextTrack(GSTrack track, boolean descending, boolean cycle) {
        UUID nextTrackUUID = this.getNextTrack(track.getTrackUUID(), descending, cycle);
        return nextTrackUUID == null ? null : this.model.getTrack(nextTrackUUID);
    }

    public UUID getNextTrack(UUID trackUUID, boolean descending, boolean cycle) {
        Integer trackIndex = this.trackUUIDToIndex.get(trackUUID);
        if (trackIndex == null) {
            return null;
        }
        int nextIndex = trackIndex;
        if (descending) {
            if (--nextIndex < 0) {
                if (!cycle) {
                    return null;
                }
                nextIndex = this.trackUUIDToIndex.size() - 1;
            }
        } else if (++nextIndex >= this.trackUUIDToIndex.size()) {
            if (!cycle) {
                return null;
            }
            nextIndex = 0;
        }
        return this.trackIndexToUUID.get(nextIndex);
    }

    public GSRectangle modelToView(GSTrackEntry entry) {
        return this.modelToView(entry, null);
    }

    public GSRectangle modelToView(GSTrackEntry entry, GSRectangle dest) {
        long duration = this.getSequenceDuration(entry.getParent().getSequence());
        if (duration == -1L) {
            return null;
        }
        if (dest == null) {
            dest = new GSRectangle();
        }
        dest.x = this.getGametickX(entry.getOffset());
        dest.width = this.getGametickX(duration + entry.getOffset()) - dest.x;
        dest.y = this.getTrackY(entry.getParent().getTrackUUID());
        dest.height = this.getTrackHeight();
        return dest;
    }

    public int getGametickX(long gametick) {
        return this.getGametickExactX(gametick);
    }

    public int getGametickExactX(double gt) {
        return (int)Math.round(gt * this.gametickWidth);
    }

    public int getGametickWidth(long gametick) {
        return this.getGametickX(gametick + 1L) - this.getGametickX(gametick);
    }

    public int getTrackY(GSTrack track) {
        return this.getTrackY(track.getTrackUUID());
    }

    public int getTrackY(UUID trackUUID) {
        Integer trackIndex = this.trackUUIDToIndex.get(trackUUID);
        if (trackIndex == null) {
            return -1;
        }
        return trackIndex * 51;
    }

    public int getMinimumWidth() {
        return this.getGametickX(this.minimumGametickCount);
    }

    public int getMinimumHeight() {
        return this.trackUUIDToIndex.size() * 51;
    }

    public GSTrackEntry getEntryAt(int x, int y) {
        GSTrack track = this.getTrackFromY(y);
        if (track != null) {
            long duration = this.getSequenceDuration(track.getSequence());
            long gt = this.getGametickFromX(x);
            for (GSTrackEntry entry : track.getEntries()) {
                if (entry.getOffset() > gt || entry.getOffset() + duration <= gt) continue;
                return entry;
            }
        }
        return null;
    }

    public long getGametickFromX(int x) {
        return this.getGametickFromExact(this.getGametickExactFromX(x));
    }

    public double getGametickExactFromX(int x) {
        return (double)x / this.gametickWidth;
    }

    public long getGametickFromExact(double gt) {
        return (long)Math.floor(gt);
    }

    public GSTrack getTrackFromY(int y) {
        if (y < 0) {
            return null;
        }
        int trackIndex = y / 51;
        UUID trackUUID = this.trackIndexToUUID.get(trackIndex);
        return trackUUID == null ? null : this.model.getTrack(trackUUID);
    }

    public int getTrackHeight() {
        return 50;
    }

    public int getTrackSpacing() {
        return 1;
    }

    public double getGametickWidth() {
        return this.gametickWidth;
    }

    public void setGametickWidth(double gametickWidth) {
        if (gametickWidth != this.gametickWidth) {
            this.gametickWidth = gametickWidth;
            this.calculateTimeIndicatorInterval();
            this.dispatchModelViewChangedEvent();
        }
    }

    public void multiplyZoom(double multiplier) {
        this.gametickWidth = GSMathUtil.clamp((double)(this.gametickWidth * multiplier), (double)0.01, (double)75.0);
        this.calculateTimeIndicatorInterval();
        this.dispatchModelViewChangedEvent();
    }

    public long getTimeIndicatorInterval() {
        return this.timeIndicatorInterval;
    }

    private void calculateTimeIndicatorInterval() {
        double minInterval = 75.0 / this.gametickWidth;
        if (minInterval <= 0.0) {
            this.timeIndicatorInterval = 1L;
        } else if (minInterval < 10.0) {
            this.timeIndicatorInterval = minInterval < 5.0 ? 5L : 10L;
        } else {
            double exponent = Math.floor(Math.log10(minInterval));
            double magnitude = Math.pow(10.0, exponent);
            double coefficient = Math.ceil(minInterval / magnitude);
            this.timeIndicatorInterval = Math.round(coefficient * magnitude);
        }
    }

    public long getTimeIndicatorFromX(int x) {
        return Math.floorDiv(this.getGametickFromX(x), this.timeIndicatorInterval) * this.timeIndicatorInterval;
    }

    public void addModelViewListener(GSIModelViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listenters.add(listener);
    }

    public void removeModelViewListener(GSIModelViewListener listener) {
        this.listenters.remove(listener);
    }

    private void dispatchModelViewChangedEvent() {
        this.listenters.forEach(GSIModelViewListener::modelViewChanged);
    }

    @Override
    public void trackAdded(GSTrack track) {
        this.updateTrackIndexLookup();
        this.updateSequenceDuration(track.getSequence());
        this.updateMinimumGametickCount();
        track.getSequence().addSequenceListener(this);
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void trackRemoved(GSTrack track) {
        track.getSequence().removeSequenceListener(this);
        this.sequenceDurations.remove(track.getSequence().getSequenceUUID());
        this.updateTrackIndexLookup();
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void trackGroupChanged(GSTrack track, UUID oldGroupUUID) {
        this.updateTrackIndexLookup();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryRemoved(GSTrackEntry entry) {
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryAdded(GSTrackEntry entry) {
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryOffsetChanged(GSTrackEntry entry, long oldOffset) {
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void channelAdded(GSChannel channel, UUID prevUUID) {
        this.updateSequenceDuration(channel.getParent());
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void channelRemoved(GSChannel channel, UUID oldPrevUUID) {
        this.updateSequenceDuration(channel.getParent());
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryAdded(GSChannelEntry entry) {
        this.updateSequenceDuration(entry.getParent().getParent());
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryRemoved(GSChannelEntry entry) {
        this.updateSequenceDuration(entry.getParent().getParent());
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryTimeChanged(GSChannelEntry entry, GSSignalTime oldStart, GSSignalTime oldEnd) {
        this.updateSequenceDuration(entry.getParent().getParent());
        this.updateMinimumGametickCount();
        this.dispatchModelViewChangedEvent();
    }
}

