/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.session.GSIUndoRedoListener;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSUndoRedoHistory;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSECursorType;
import com.g4mesoft.ui.panel.GSEIconAlignment;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSTexturedIcon;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSTextUtil;
import net.minecraft.class_2561;

public class GSSequenceInfoPanel
extends GSParentPanel
implements GSIUndoRedoListener {
    private static final GSIcon UNDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 27, 9, 9));
    private static final GSIcon HOVERED_UNDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 36, 9, 9));
    private static final GSIcon DISABLED_UNDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 45, 9, 9));
    private static final GSIcon REDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 27, 9, 9));
    private static final GSIcon HOVERED_REDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 36, 9, 9));
    private static final GSIcon DISABLED_REDO_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 45, 9, 9));
    private static final class_2561 UNDO_TEXT = GSTextUtil.translatable((String)"panel.edit.undo");
    private static final class_2561 REDO_TEXT = GSTextUtil.translatable((String)"panel.edit.redo");
    private static final int BUTTON_MARGIN = 2;
    private final GSUndoRedoHistory history;
    private final GSButton undoButton;
    private final GSButton redoButton;

    public GSSequenceInfoPanel(GSSession session) {
        this.history = session.get(GSSession.UNDO_REDO_HISTORY);
        this.undoButton = new GSButton(UNDO_ICON, UNDO_TEXT);
        this.undoButton.setHoveredIcon(HOVERED_UNDO_ICON);
        this.undoButton.setDisabledIcon(DISABLED_UNDO_ICON);
        this.undoButton.setIconAlignment(GSEIconAlignment.LEFT);
        this.undoButton.setCursor(GSECursorType.HAND);
        this.undoButton.setBackgroundColor(0);
        this.undoButton.setHoveredBackgroundColor(0);
        this.undoButton.setDisabledBackgroundColor(0);
        this.undoButton.setBorderWidth(0);
        this.undoButton.addActionListener(this.history::undo);
        this.redoButton = new GSButton(REDO_ICON, REDO_TEXT);
        this.redoButton.setHoveredIcon(HOVERED_REDO_ICON);
        this.redoButton.setDisabledIcon(DISABLED_REDO_ICON);
        this.redoButton.setIconAlignment(GSEIconAlignment.LEFT);
        this.redoButton.setCursor(GSECursorType.HAND);
        this.redoButton.setBackgroundColor(0);
        this.redoButton.setHoveredBackgroundColor(0);
        this.redoButton.setDisabledBackgroundColor(0);
        this.redoButton.setBorderWidth(0);
        this.redoButton.addActionListener(this.history::redo);
        this.add((GSPanel)this.undoButton);
        this.add((GSPanel)this.redoButton);
    }

    protected void layout() {
        GSDimension undoPrefS = (GSDimension)this.undoButton.getProperty(PREFERRED_SIZE);
        GSDimension redoPrefS = (GSDimension)this.redoButton.getProperty(PREFERRED_SIZE);
        int bx = 2;
        int by = Math.min(this.height - undoPrefS.getHeight(), this.height - redoPrefS.getHeight()) - 2;
        this.undoButton.setBounds(bx, by, undoPrefS.getWidth(), undoPrefS.getHeight());
        this.redoButton.setBounds(bx += undoPrefS.getWidth() + 2, by, redoPrefS.getWidth(), redoPrefS.getHeight());
    }

    protected void onShown() {
        super.onShown();
        this.history.addUndoRedoListener(this);
        this.onHistoryChanged();
    }

    protected void onHidden() {
        super.onHidden();
        this.history.removeUndoRedoListener(this);
    }

    public void render(GSIRenderer2D renderer) {
        renderer.fillRect(0, 0, this.width, this.height, -15263977);
        renderer.drawVLine(this.width - 1, 0, this.height, -14671840);
        renderer.drawHLine(0, this.width, this.height - 1, -14671840);
        super.render(renderer);
    }

    @Override
    public void onHistoryChanged() {
        this.undoButton.setEnabled(this.history.hasUndoHistory());
        this.redoButton.setEnabled(this.history.hasRedoHistory());
    }
}

