/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public class GSChannelEntryTime {
    private final GSSignalTime time;
    private final int subordering;

    public GSChannelEntryTime(GSSignalTime time, int subordering) {
        this.time = time;
        this.subordering = subordering;
    }

    public GSChannelEntryTime offsetCopy(long gtOffset, int mtOffset) {
        return new GSChannelEntryTime(this.time.offsetCopy(gtOffset, mtOffset), this.subordering);
    }

    public GSSignalTime getTime() {
        return this.time;
    }

    public int getSubordering() {
        return this.subordering;
    }

    public int hashCode() {
        return this.time.hashCode() + 31 * this.subordering;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GSChannelEntryTime)) {
            return false;
        }
        GSChannelEntryTime entryTime = (GSChannelEntryTime)other;
        if (!this.time.isEqual(entryTime.time)) {
            return false;
        }
        return this.subordering == entryTime.subordering;
    }

    public static GSChannelEntryTime read(GSDecodeBuffer buf) throws IOException {
        GSSignalTime time = GSSignalTime.read(buf);
        int subordering = buf.readInt();
        if (subordering < 0) {
            throw new IOException("Invalid sub-ordering!");
        }
        return new GSChannelEntryTime(time, subordering);
    }

    public static void write(GSEncodeBuffer buf, GSChannelEntryTime entryTime) throws IOException {
        GSSignalTime.write(buf, entryTime.time);
        buf.writeInt(entryTime.subordering);
    }
}

