/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelEntryTypeDelta
extends GSChannelEntryDelta {
    private GSEChannelEntryType newType;
    private GSEChannelEntryType oldType;

    public GSChannelEntryTypeDelta() {
    }

    public GSChannelEntryTypeDelta(UUID channelUUID, UUID entryUUID, GSEChannelEntryType newType, GSEChannelEntryType oldType) {
        super(channelUUID, entryUUID);
        this.newType = newType;
        this.oldType = oldType;
    }

    private void setEntryType(GSEChannelEntryType newType, GSEChannelEntryType oldType, GSSequence sequence) throws GSDeltaException {
        GSChannelEntry entry = this.getEntry(sequence);
        this.checkEntryType(entry, oldType);
        entry.setType(newType);
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.setEntryType(this.oldType, this.newType, sequence);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.setEntryType(this.newType, this.oldType, sequence);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newType = GSEChannelEntryType.fromIndex(buf.readInt());
        this.oldType = GSEChannelEntryType.fromIndex(buf.readInt());
        if (this.newType == null || this.oldType == null) {
            throw new IOException("Invalid type index!");
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeInt(this.newType.getIndex());
        buf.writeInt(this.oldType.getIndex());
    }
}

