/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSDeltaRegistries;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSSequenceSessionField;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSSessionField;
import com.g4mesoft.captureplayback.session.GSSessionFieldType;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public class GSSequenceSessionDelta
implements GSIDelta<GSSession> {
    private GSSessionFieldType<?> type;
    private GSIDelta<GSSequence> delta;

    public GSSequenceSessionDelta() {
    }

    public GSSequenceSessionDelta(GSSessionFieldType<GSSequence> type, GSIDelta<GSSequence> delta) {
        this.type = type;
        this.delta = delta;
    }

    @Override
    public void apply(GSSession session) throws GSDeltaException {
        GSSessionField<?> field = session.getField(this.type);
        if (!(field instanceof GSSequenceSessionField)) {
            throw new GSDeltaException("Field '" + this.type.getName() + "' is not a sequence.");
        }
        ((GSSequenceSessionField)field).applyDelta(this.delta);
    }

    @Override
    public void unapply(GSSession session) throws GSDeltaException {
        throw new GSDeltaException("Unapply unsupported.");
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.type = GSSession.readFieldType(buf);
        this.delta = GSDeltaRegistries.SEQUENCE_DELTA_REGISTRY.read(buf);
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        GSSession.writeFieldType(buf, this.type);
        GSDeltaRegistries.SEQUENCE_DELTA_REGISTRY.write(buf, this.delta);
    }
}

