/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaRegistries;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.module.client.GSCapturePlaybackClientModule;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSSessionDeltasPacket
implements GSIPacket {
    private UUID assetUUID;
    private GSIDelta<GSSession>[] deltas;

    public GSSessionDeltasPacket() {
    }

    public GSSessionDeltasPacket(UUID assetUUID, GSIDelta<GSSession>[] deltas) {
        this.assetUUID = assetUUID;
        this.deltas = deltas;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.assetUUID = buf.readUUID();
        int deltaCount = buf.readInt();
        GSIDelta[] deltas = new GSIDelta[deltaCount];
        int i = 0;
        while (deltaCount-- != 0) {
            GSIDelta<GSSession> delta;
            try {
                delta = GSDeltaRegistries.SESSION_DELTA_REGISTRY.read(buf);
            }
            catch (IOException ignore) {
                continue;
            }
            deltas[i++] = delta;
        }
        if (i == 0) {
            throw new IOException("Unable to decode deltas");
        }
        if (i != deltas.length) {
            deltas = Arrays.copyOf(deltas, i);
        }
        this.deltas = deltas;
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUUID(this.assetUUID);
        buf.writeInt(this.deltas.length);
        for (GSIDelta<GSSession> delta : this.deltas) {
            GSDeltaRegistries.SESSION_DELTA_REGISTRY.write(buf, delta);
        }
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        if (module != null) {
            module.onSessionDeltasReceived(player, this.assetUUID, this.deltas);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
        GSCapturePlaybackClientModule module = (GSCapturePlaybackClientModule)controller.getModule(GSCapturePlaybackClientModule.class);
        if (module != null) {
            module.getAssetManager().onSessionDeltasReceived(this.assetUUID, this.deltas);
        }
    }
}

