package archives.tater.savestate;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_442;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Set;

public class SaveState implements ModInitializer {
	public static final String MOD_ID = "savestate";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	public static final String SAVE_DIR = MOD_ID + "_save";

	public static final Set<String> IGNORED_PATHS = Set.of(
			SAVE_DIR,
			"session.lock"
	);

	private static void deleteRecursive(Path path) throws IOException {
		try (var stream = Files.walk(path)) {
			for (var path2 : (Iterable<Path>) stream.sorted(Comparator.reverseOrder())::iterator)
				Files.delete(path2);
		}
	}

	private static void copyRecursive(Path src, Path dest) throws IOException {
		if (Files.isDirectory(src))
			FileUtils.copyDirectoryToDirectory(src.toFile(), dest.toFile());
		else
			Files.copy(src, dest.resolve(src.getFileName()));
	}

	public static void save(MinecraftServer server) {
		server.method_39218(false, true, true);
		var levelPath = server.method_27050(class_5218.field_24188);
		var savePath = levelPath.resolve(SAVE_DIR);
		try {
			if (Files.isDirectory(savePath))
				try (var stream = Files.newDirectoryStream(savePath)) {
					for (var path : stream)
						deleteRecursive(path);
				}
			else
				Files.createDirectory(savePath);

			try (var stream = Files.newDirectoryStream(levelPath)) {
				for (var path : stream) {
					if (IGNORED_PATHS.contains(path.getFileName().toString())) continue;
					copyRecursive(path, savePath);
				}
			}
		} catch (IOException e) {
			LOGGER.error("Error creating save: ", e);
		}
	}

	public static void loadSave(MinecraftServer server) {
        var levelPath = server.method_27050(class_5218.field_24188);
		var client = class_310.method_1551();
        client.method_73360(class_2561.method_43470("Loading save..."));

		var savePath = levelPath.resolve(SAVE_DIR);
		try {
			try (var stream = Files.newDirectoryStream(levelPath)) {
				for (var path : stream) {
					if (IGNORED_PATHS.contains(path.getFileName().toString())) continue;
					deleteRecursive(path);
				}
			}
			try (var stream = Files.newDirectoryStream(savePath)) {
				for (var path : stream) {
					copyRecursive(path, levelPath);
				}
			}
		} catch (IOException e) {
			LOGGER.error("Error loading save: ", e);
		}

		client.method_41735().method_57784(levelPath.normalize().getFileName().toString(), () -> client.method_1507(new class_442()));
	}

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.

		ServerLifecycleEvents.SERVER_STARTED.register(server -> {
			var client = class_310.method_1551();
			if (!client.method_1496()) return;
			if (Files.exists(server.method_27050(class_5218.field_24188).resolve(SAVE_DIR).resolve("level.dat"))) return;

			save(server);
		});
	}
}