/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.savestate;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveState
implements ModInitializer {
    public static final String MOD_ID = "savestate";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"savestate");
    public static final String SAVE_DIR = "savestate_save";
    public static final Set<String> IGNORED_PATHS = Set.of("savestate_save", "session.lock");

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void deleteRecursive(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            for (Path path2 : stream.sorted(Comparator.reverseOrder())::iterator) {
                Files.delete(path2);
            }
        }
    }

    private static void copyRecursive(Path src, Path dest) throws IOException {
        if (Files.isDirectory(src, new LinkOption[0])) {
            FileUtils.copyDirectoryToDirectory((File)src.toFile(), (File)dest.toFile());
        } else {
            Files.copy(src, dest.resolve(src.getFileName()), new CopyOption[0]);
        }
    }

    public static void save(MinecraftServer server) {
        server.method_39218(false, true, true);
        Path levelPath = server.method_27050(class_5218.field_24188);
        Path savePath = levelPath.resolve(SAVE_DIR);
        try {
            DirectoryStream<Path> stream;
            if (Files.isDirectory(savePath, new LinkOption[0])) {
                stream = Files.newDirectoryStream(savePath);
                try {
                    for (Path path : stream) {
                        SaveState.deleteRecursive(path);
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            } else {
                Files.createDirectory(savePath, new FileAttribute[0]);
            }
            stream = Files.newDirectoryStream(levelPath);
            try {
                for (Path path : stream) {
                    if (IGNORED_PATHS.contains(path.getFileName().toString())) continue;
                    SaveState.copyRecursive(path, savePath);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error creating save: ", (Throwable)e);
        }
    }

    public static void loadSave(MinecraftServer server) {
        Path levelPath = server.method_27050(class_5218.field_24188);
        class_310 client = class_310.method_1551();
        client.method_73360((class_2561)class_2561.method_43470((String)"Loading save..."));
        Path savePath = levelPath.resolve(SAVE_DIR);
        try {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(levelPath);){
                for (Path path : stream) {
                    if (IGNORED_PATHS.contains(path.getFileName().toString())) continue;
                    SaveState.deleteRecursive(path);
                }
            }
            stream = Files.newDirectoryStream(savePath);
            try {
                for (Path path : stream) {
                    SaveState.copyRecursive(path, levelPath);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading save: ", (Throwable)e);
        }
        client.method_41735().method_57784(levelPath.normalize().getFileName().toString(), () -> client.method_1507((class_437)new class_442()));
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_310 client = class_310.method_1551();
            if (!client.method_1496()) {
                return;
            }
            if (Files.exists(server.method_27050(class_5218.field_24188).resolve(SAVE_DIR).resolve("level.dat"), new LinkOption[0])) {
                return;
            }
            SaveState.save(server);
        });
    }
}

