/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.widget;

import com.cleanroommc.modularui.api.UpOrDown;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public interface Interactable {
    @NotNull
    default public Result onMousePressed(int mouseButton) {
        return Result.ACCEPT;
    }

    default public boolean onMouseRelease(int mouseButton) {
        return false;
    }

    @NotNull
    default public Result onMouseTapped(int mouseButton) {
        return Result.IGNORE;
    }

    @NotNull
    default public Result onKeyPressed(char typedChar, int keyCode) {
        return Result.IGNORE;
    }

    default public boolean onKeyRelease(char typedChar, int keyCode) {
        return false;
    }

    @NotNull
    default public Result onKeyTapped(char typedChar, int keyCode) {
        return Result.IGNORE;
    }

    default public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        return false;
    }

    default public void onMouseDrag(int mouseButton, long timeSinceClick) {
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasControlDown() {
        return GuiScreen.isCtrlKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasShiftDown() {
        return GuiScreen.isShiftKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasAltDown() {
        return GuiScreen.isAltKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isKeyPressed(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playButtonClickSound() {
        Minecraft.getMinecraft().getSoundHandler().playSound((ISound)PositionedSoundRecord.getMasterRecord((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static enum Result {
        IGNORE(false, false),
        ACCEPT(true, false),
        STOP(false, true),
        SUCCESS(true, true);

        public final boolean accepts;
        public final boolean stops;

        private Result(boolean accepts, boolean stops) {
            this.accepts = accepts;
            this.stops = stops;
        }
    }
}

