/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.RichTooltipEvent;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class GuiDraw {
    private static final TextRenderer textRenderer = new TextRenderer();
    public static final double PI2 = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;

    public static void drawRect(float x0, float y0, float w, float h, int color) {
        Platform.setupDrawColor();
        float x1 = x0 + w;
        float y1 = y0 + h;
        float r = Color.getRedF(color);
        float g = Color.getGreenF(color);
        float b = Color.getBlueF(color);
        float a = Color.getAlphaF(color);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x0, (double)y0, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x0, (double)y1, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(r, g, b, a).endVertex();
            bufferBuilder.pos((double)x1, (double)y0, 0.0).color(r, g, b, a).endVertex();
        });
    }

    public static void drawHorizontalGradientRect(float x0, float y0, float w, float h, int colorLeft, int colorRight) {
        GuiDraw.drawRect(x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight);
    }

    public static void drawVerticalGradientRect(float x0, float y0, float w, float h, int colorTop, int colorBottom) {
        GuiDraw.drawRect(x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR) {
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        float x1 = x0 + w;
        float y1 = y0 + h;
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x0, (double)y0, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
            bufferBuilder.pos((double)x0, (double)y1, 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
            bufferBuilder.pos((double)x1, (double)y0, 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
        });
        Platform.endDrawGradient();
    }

    public static void drawCircle(float x0, float y0, float diameter, int color, int segments) {
        GuiDraw.drawEllipse(x0, y0, diameter, diameter, color, color, segments);
    }

    public static void drawCircle(float x0, float y0, float diameter, int centerColor, int outerColor, int segments) {
        GuiDraw.drawEllipse(x0, y0, diameter, diameter, centerColor, outerColor, segments);
    }

    public static void drawEllipse(float x0, float y0, float w, float h, int color, int segments) {
        GuiDraw.drawEllipse(x0, y0, w, h, color, color, segments);
    }

    public static void drawEllipse(float x0, float y0, float w, float h, int centerColor, int outerColor, int segments) {
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        float x_2 = x0 + w / 2.0f;
        float y_2 = y0 + h / 2.0f;
        Platform.startDrawing(Platform.DrawMode.TRIANGLE_FAN, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x_2, (double)y_2, 0.0).color(Color.getRed(centerColor), Color.getGreen(centerColor), Color.getBlue(centerColor), Color.getAlpha(centerColor)).endVertex();
            int a = Color.getAlpha(outerColor);
            int r = Color.getRed(outerColor);
            int g = Color.getGreen(outerColor);
            int b = Color.getBlue(outerColor);
            float incr = (float)(Math.PI * 2 / (double)segments);
            for (int i = 0; i <= segments; ++i) {
                float angle = incr * (float)i;
                float x = (float)(Math.sin(angle) * (double)(w / 2.0f) + (double)x_2);
                float y = (float)(Math.cos(angle) * (double)(h / 2.0f) + (double)y_2);
                bufferBuilder.pos((double)x, (double)y, 0.0).color(r, g, b, a).endVertex();
            }
        });
        Platform.endDrawGradient();
    }

    public static void drawRoundedRect(float x0, float y0, float w, float h, int color, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, color, color, color, color, cornerRadius, segments);
    }

    public static void drawVerticalGradientRoundedRect(float x0, float y0, float w, float h, int colorTop, int colorBottom, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom, cornerRadius, segments);
    }

    public static void drawHorizontalGradientRoundedRect(float x0, float y0, float w, float h, int colorLeft, int colorRight, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight, cornerRadius, segments);
    }

    public static void drawRoundedRect(float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR, int cornerRadius, int segments) {
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        float x1 = x0 + w;
        float y1 = y0 + h;
        Platform.startDrawing(Platform.DrawMode.TRIANGLE_FAN, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            float y;
            float x;
            int i;
            int color = Color.average(colorBL, colorBR, colorTR, colorTL);
            bufferBuilder.pos((double)(x0 + w / 2.0f), (double)(y0 + h / 2.0f), 0.0).color(Color.getRed(color), Color.getGreen(color), Color.getBlue(color), Color.getAlpha(color)).endVertex();
            bufferBuilder.pos((double)x0, (double)(y0 + (float)cornerRadius), 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
            bufferBuilder.pos((double)x0, (double)(y1 - (float)cornerRadius), 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
            for (i = 1; i <= segments; ++i) {
                x = (float)((double)(x0 + (float)cornerRadius) - Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                y = (float)((double)(y1 - (float)cornerRadius) + Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                bufferBuilder.pos((double)x, (double)y, 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
            }
            bufferBuilder.pos((double)(x1 - (float)cornerRadius), (double)y1, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
            for (i = 1; i <= segments; ++i) {
                x = (float)((double)(x1 - (float)cornerRadius) + Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                y = (float)((double)(y1 - (float)cornerRadius) + Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                bufferBuilder.pos((double)x, (double)y, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
            }
            bufferBuilder.pos((double)x1, (double)(y0 + (float)cornerRadius), 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
            for (i = 1; i <= segments; ++i) {
                x = (float)((double)(x1 - (float)cornerRadius) + Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                y = (float)((double)(y0 + (float)cornerRadius) - Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                bufferBuilder.pos((double)x, (double)y, 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
            }
            bufferBuilder.pos((double)(x0 + (float)cornerRadius), (double)y0, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
            for (i = 1; i <= segments; ++i) {
                x = (float)((double)(x0 + (float)cornerRadius) - Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                y = (float)((double)(y0 + (float)cornerRadius) - Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
                bufferBuilder.pos((double)x, (double)y, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
            }
            bufferBuilder.pos((double)x0, (double)(y0 + (float)cornerRadius), 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        });
        Platform.endDrawGradient();
    }

    public static void drawTexture(ResourceLocation location, float x, float y, float w, float h, int u, int v, int textureWidth, int textureHeight) {
        Platform.setupDrawTex(location);
        GuiDraw.drawTexture(x, y, u, v, w, h, textureWidth, textureHeight);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH) {
        GuiDraw.drawTexture(x, y, u, v, w, h, textureW, textureH, 0.0f);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> GuiDraw.drawTexture(bufferBuilder, x, y, u, v, w, h, textureW, textureH, z));
    }

    public static void drawTexture(BufferBuilder buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.pos((double)x, (double)(y + h), (double)z).tex((double)((float)u * tw), (double)(((float)v + h) * th)).endVertex();
        buffer.pos((double)(x + w), (double)(y + h), (double)z).tex((double)(((float)u + w) * tw), (double)(((float)v + h) * th)).endVertex();
        buffer.pos((double)(x + w), (double)y, (double)z).tex((double)(((float)u + w) * tw), (double)((float)v * th)).endVertex();
        buffer.pos((double)x, (double)y, (double)z).tex((double)((float)u * tw), (double)((float)v * th)).endVertex();
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv) {
        GuiDraw.drawTexture(x, y, u, v, w, h, textureW, textureH, tu, tv, 0.0f);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> GuiDraw.drawTexture(bufferBuilder, x, y, u, v, w, h, textureW, textureH, tu, tv, z));
    }

    public static void drawTexture(BufferBuilder buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.pos((double)x, (double)(y + h), (double)z).tex((double)((float)u * tw), (double)((float)tv * th)).endVertex();
        buffer.pos((double)(x + w), (double)(y + h), (double)z).tex((double)((float)tu * tw), (double)((float)tv * th)).endVertex();
        buffer.pos((double)(x + w), (double)y, (double)z).tex((double)((float)tu * tw), (double)((float)v * th)).endVertex();
        buffer.pos((double)x, (double)y, (double)z).tex((double)((float)u * tw), (double)((float)v * th)).endVertex();
    }

    public static void drawTexture(ResourceLocation location, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        Platform.setupDrawTex(location);
        GuiDraw.drawTexture(x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
    }

    public static void drawTexture(float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GuiDraw.drawTexture(x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
    }

    public static void drawTexture(float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> GuiDraw.drawTexture(bufferBuilder, x0, y0, x1, y1, u0, v0, u1, v1, z));
    }

    public static void drawTexture(BufferBuilder buffer, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        buffer.pos((double)x0, (double)y1, (double)z).tex((double)u0, (double)v1).endVertex();
        buffer.pos((double)x1, (double)y1, (double)z).tex((double)u1, (double)v1).endVertex();
        buffer.pos((double)x1, (double)y0, (double)z).tex((double)u1, (double)v0).endVertex();
        buffer.pos((double)x0, (double)y0, (double)z).tex((double)u0, (double)v0).endVertex();
    }

    public static void drawTiledTexture(ResourceLocation location, float x, float y, float w, float h, int u, int v, int tileW, int tileH, int tw, int th, float z) {
        Platform.setupDrawTex(location);
        GuiDraw.drawTiledTexture(x, y, w, h, u, v, tileW, tileH, tw, th, z);
    }

    public static void drawTiledTexture(float x, float y, float w, float h, int u, int v, int tileW, int tileH, int tw, int th, float z) {
        int countX = ((int)w - 1) / tileW + 1;
        int countY = ((int)h - 1) / tileH + 1;
        float fillerX = w - (float)((countX - 1) * tileW);
        float fillerY = h - (float)((countY - 1) * tileH);
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> {
            int c = countX * countY;
            for (int i = 0; i < c; ++i) {
                int ix = i % countX;
                int iy = i / countX;
                float xx = x + (float)(ix * tileW);
                float yy = y + (float)(iy * tileH);
                float xw = ix == countX - 1 ? fillerX : (float)tileW;
                float yh = iy == countY - 1 ? fillerY : (float)tileH;
                GuiDraw.drawTexture(bufferBuilder, xx, yy, u, v, xw, yh, tw, th, z);
            }
        });
    }

    public static void drawTiledTexture(ResourceLocation location, float x, float y, float w, float h, float u0, float v0, float u1, float v1, int textureWidth, int textureHeight, float z) {
        Platform.setupDrawTex(location);
        GuiDraw.drawTiledTexture(x, y, w, h, u0, v0, u1, v1, textureWidth, textureHeight, z);
    }

    public static void drawTiledTexture(float x, float y, float w, float h, float u0, float v0, float u1, float v1, int tileWidth, int tileHeight, float z) {
        int countX = ((int)w - 1) / tileWidth + 1;
        int countY = ((int)h - 1) / tileHeight + 1;
        float fillerX = w - (float)((countX - 1) * tileWidth);
        float fillerY = h - (float)((countY - 1) * tileHeight);
        float fillerU = u0 + (u1 - u0) * fillerX / (float)tileWidth;
        float fillerV = v0 + (v1 - v0) * fillerY / (float)tileHeight;
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_TEX, bufferBuilder -> {
            int c = countX * countY;
            for (int i = 0; i < c; ++i) {
                int ix = i % countX;
                int iy = i / countX;
                float xx = x + (float)(ix * tileWidth);
                float yy = y + (float)(iy * tileHeight);
                float xw = tileWidth;
                float yh = tileHeight;
                float uEnd = u1;
                float vEnd = v1;
                if (ix == countX - 1) {
                    xw = fillerX;
                    uEnd = fillerU;
                }
                if (iy == countY - 1) {
                    yh = fillerY;
                    vEnd = fillerV;
                }
                GuiDraw.drawTexture(bufferBuilder, xx, yy, xx + xw, yy + yh, u0, v0, uEnd, vEnd, z);
            }
        });
    }

    public static void drawItem(ItemStack item, int x, int y, float width, float height, int z) {
        if (item.isEmpty()) {
            return;
        }
        GlStateManager.pushMatrix();
        Platform.setupDrawItem();
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        GlStateManager.scale((float)(width / 16.0f), (float)(height / 16.0f), (float)1.0f);
        RenderItem renderItem = Minecraft.getMinecraft().getRenderItem();
        renderItem.zLevel = z + 100;
        renderItem.renderItemAndEffectIntoGUI((EntityLivingBase)Platform.getClientPlayer(), item, 0, 0);
        renderItem.zLevel = 0.0f;
        Platform.endDrawItem();
        GlStateManager.popMatrix();
    }

    public static void drawFluidTexture(FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null) {
            return;
        }
        Fluid fluid = content.getFluid();
        ResourceLocation fluidStill = fluid.getStill(content);
        TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(fluidStill.toString());
        int fluidColor = fluid.getColor(content);
        GlStateManager.color((float)Color.getRedF(fluidColor), (float)Color.getGreenF(fluidColor), (float)Color.getBlueF(fluidColor), (float)Color.getAlphaF(fluidColor));
        GuiDraw.drawTiledTexture(TextureMap.LOCATION_BLOCKS_TEXTURE, x0, y0, width, height, sprite.getMinU(), sprite.getMinV(), sprite.getMaxU(), sprite.getMaxV(), sprite.getIconWidth(), sprite.getIconHeight(), z);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawStandardSlotAmountText(int amount, String format, Area area) {
        GuiDraw.drawAmountText(amount, format, 1, 1, area.width - 1, area.height - 1, Alignment.BottomRight);
    }

    public static void drawAmountText(int amount, String format, int x, int y, int width, int height, Alignment alignment) {
        if (amount > 1 || format != null) {
            String amountText = NumberFormat.AMOUNT_TEXT.format(amount);
            if (format != null) {
                amountText = format + amountText;
            }
            float scale = 1.0f;
            if (amountText.length() == 3) {
                scale = 0.8f;
            } else if (amountText.length() == 4) {
                scale = 0.6f;
            } else if (amountText.length() > 4) {
                scale = 0.5f;
            }
            textRenderer.setShadow(true);
            textRenderer.setScale(scale);
            textRenderer.setColor(Color.WHITE.main);
            textRenderer.setAlignment(alignment, width, height);
            textRenderer.setPos(x, y);
            textRenderer.setHardWrapOnBorder(false);
            textRenderer.draw(amountText);
            textRenderer.setHardWrapOnBorder(true);
        }
    }

    public static void drawSprite(TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        GuiDraw.drawSprite(Minecraft.getMinecraft().getTextureMapBlocks(), sprite, x0, y0, w, h);
    }

    public static void drawSprite(TextureMap textureMap, TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        Platform.setupDrawTex(textureMap.getGlTextureId());
        GuiDraw.drawTexture(x0, y0, x0 + w, y0 + h, sprite.getMinU(), sprite.getMinV(), sprite.getMaxU(), sprite.getMaxV());
    }

    public static void drawTiledSprite(TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        GuiDraw.drawTiledSprite(Minecraft.getMinecraft().getTextureMapBlocks(), sprite, x0, y0, w, h);
    }

    public static void drawTiledSprite(TextureMap textureMap, TextureAtlasSprite sprite, float x0, float y0, float w, float h) {
        GlStateManager.disableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.enableTexture2D();
        GlStateManager.bindTexture((int)textureMap.getGlTextureId());
        GuiDraw.drawTiledTexture(x0, y0, x0 + w, y0 + h, sprite.getMinU(), sprite.getMinV(), sprite.getMaxU(), sprite.getMaxV(), sprite.getIconWidth(), sprite.getIconHeight(), 0.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color) {
        GuiDraw.drawOutlineCenter(x, y, offset, color, 1);
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color, int border) {
        GuiDraw.drawOutline(x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color) {
        GuiDraw.drawOutline(left, top, right, bottom, color, 1);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color, int border) {
        Gui.drawRect((int)left, (int)top, (int)(left + border), (int)bottom, (int)color);
        Gui.drawRect((int)(right - border), (int)top, (int)right, (int)bottom, (int)color);
        Gui.drawRect((int)(left + border), (int)top, (int)(right - border), (int)(top + border), (int)color);
        Gui.drawRect((int)(left + border), (int)(bottom - border), (int)(right - border), (int)bottom, (int)color);
    }

    public static void drawDropShadow(int x, int y, int w, int h, int oX, int oY, int opaque, int shadow) {
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            float x1 = x + w;
            float y1 = y + h;
            bufferBuilder.pos((double)x1, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)(x1 + (float)oX), (double)(y - oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)(x - oX), (double)(y - oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)x, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x1, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)(x - oX), (double)(y1 + (float)oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)(x1 + (float)oX), (double)(y1 + (float)oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)x, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)(x - oX), (double)(y - oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)(x - oX), (double)(y1 + (float)oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)x, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)(x1 + (float)oX), (double)(y - oY), 0.0).color(r2, g2, b2, a2).endVertex();
            bufferBuilder.pos((double)x1, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)x1, (double)y1, 0.0).color(r1, g1, b1, a1).endVertex();
            bufferBuilder.pos((double)(x1 + (float)oX), (double)(y1 + (float)oY), 0.0).color(r2, g2, b2, a2).endVertex();
        });
        Platform.endDrawGradient();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int segments, int opaque, int shadow) {
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        Platform.startDrawing(Platform.DrawMode.TRIANGLE_FAN, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            for (int i = 0; i <= segments; ++i) {
                double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
                bufferBuilder.pos((double)x - Math.cos(a) * (double)radius, (double)y + Math.sin(a) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
            }
        });
        Platform.endDrawGradient();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        if (offset >= radius) {
            GuiDraw.drawDropCircleShadow(x, y, radius, segments, opaque, shadow);
            return;
        }
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        Platform.setupDrawColor();
        Platform.setupDrawGradient();
        Platform.startDrawing(Platform.DrawMode.TRIANGLE_FAN, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            bufferBuilder.pos((double)x, (double)y, 0.0).color(r1, g1, b1, a1).endVertex();
            for (int i = 0; i <= segments; ++i) {
                double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
                bufferBuilder.pos((double)x - Math.cos(a) * (double)offset, (double)y + Math.sin(a) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
            }
        });
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS_COLOR, bufferBuilder -> {
            for (int i = 0; i < segments; ++i) {
                double alpha1 = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
                double alpha2 = (double)(i + 1) / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
                bufferBuilder.pos((double)x - Math.cos(alpha2) * (double)offset, (double)y + Math.sin(alpha2) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
                bufferBuilder.pos((double)x - Math.cos(alpha1) * (double)offset, (double)y + Math.sin(alpha1) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
                bufferBuilder.pos((double)x - Math.cos(alpha1) * (double)radius, (double)y + Math.sin(alpha1) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
                bufferBuilder.pos((double)x - Math.cos(alpha2) * (double)radius, (double)y + Math.sin(alpha2) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
            }
        });
        Platform.endDrawGradient();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(float x, float y, float width, float height, int color, float border) {
        GuiDraw.drawRect(x - border, y - border, width + 2.0f * border, border, color);
        GuiDraw.drawRect(x - border, y + height, width + 2.0f * border, border, color);
        GuiDraw.drawRect(x - border, y, border, height, color);
        GuiDraw.drawRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
        Platform.setupDrawFont();
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)scale, (float)scale, (float)0.0f);
        float sf = 1.0f / scale;
        fontRenderer.drawString(text, x * sf, y * sf, color, shadow);
        GlStateManager.popMatrix();
    }

    public static void drawTooltipBackground(ItemStack stack, List<String> lines, int x, int y, int textWidth, int height, @Nullable RichTooltip tooltip) {
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderTooltipEvent.Color colorEvent = tooltip != null ? new RichTooltipEvent.Color(stack, lines, x, y, TextRenderer.getFontRenderer(), backgroundColor, borderColorStart, borderColorEnd, tooltip) : new RenderTooltipEvent.Color(stack, lines, x, y, TextRenderer.getFontRenderer(), backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiDraw.drawVerticalGradientRect(x - 3, y - 4, textWidth + 6, 1.0f, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y + height + 3, textWidth + 6, 1.0f, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 3, textWidth + 6, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 4, y - 3, 1.0f, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x + textWidth + 3, y - 3, 1.0f, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(x + textWidth + 2, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 3, textWidth + 6, 1.0f, borderColorStart, borderColorStart);
        GuiDraw.drawVerticalGradientRect(x - 3, y + height + 2, textWidth + 6, 1.0f, borderColorEnd, borderColorEnd);
    }

    public static void drawEntityRaw(Entity entity) {
        RenderManager rendermanager = Minecraft.getMinecraft().getRenderManager();
        rendermanager.setPlayerViewY(180.0f);
        rendermanager.setRenderShadow(false);
        rendermanager.renderEntity(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.setRenderShadow(true);
    }

    public static <T extends Entity> void drawEntity(T entity, float x, float y, float w, float h, float z, @Nullable Consumer<T> preDraw, @Nullable Consumer<T> postDraw) {
        GlStateManager.pushMatrix();
        Platform.setupDrawEntity(entity, x, y, w, h, z);
        if (preDraw != null) {
            preDraw.accept(entity);
        }
        GuiDraw.drawEntityRaw(entity);
        if (postDraw != null) {
            postDraw.accept(entity);
        }
        Platform.endDrawEntity();
        GlStateManager.popMatrix();
    }

    public static void drawEntityLookingAtMouse(EntityLivingBase entity, float x, float y, float w, float h, float z, int mouseX, int mouseY) {
        GlStateManager.pushMatrix();
        Platform.setupDrawEntity((Entity)entity, x, y, w, h, z);
        float f = entity.renderYawOffset;
        float f1 = entity.rotationYaw;
        float f2 = entity.rotationPitch;
        float f3 = entity.prevRotationYawHead;
        float f4 = entity.rotationYawHead;
        GlStateManager.rotate((float)(-((float)Math.atan((float)mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.renderYawOffset = (float)Math.atan((float)mouseX / 40.0f) * 20.0f;
        entity.rotationYaw = (float)Math.atan((float)mouseX / 40.0f) * 40.0f;
        entity.rotationPitch = -((float)Math.atan((float)mouseY / 40.0f)) * 20.0f;
        entity.rotationYawHead = entity.rotationYaw;
        entity.prevRotationYawHead = entity.rotationYaw;
        GuiDraw.drawEntityRaw((Entity)entity);
        entity.renderYawOffset = f;
        entity.rotationYaw = f1;
        entity.rotationPitch = f2;
        entity.prevRotationYawHead = f3;
        entity.rotationYawHead = f4;
        Platform.endDrawEntity();
        GlStateManager.popMatrix();
    }
}

