/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory.inventory;

import baubles.api.BaublesApi;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.factory.inventory.Inventory;
import com.cleanroommc.modularui.factory.inventory.InventoryType;
import com.cleanroommc.modularui.factory.inventory.InventoryVisitor;
import com.cleanroommc.modularui.factory.inventory.ItemHandler;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class InventoryTypes {
    public static final InventoryType PLAYER = new Inventory("player"){

        @Override
        public IInventory getInventory(EntityPlayer player) {
            return player.inventory;
        }
    };
    public static final InventoryType BAUBLES = new ItemHandler("baubles"){

        @Override
        public boolean isActive() {
            return ModularUI.Mods.BAUBLES.isLoaded();
        }

        @Override
        public IItemHandlerModifiable getInventory(EntityPlayer player) {
            if (this.isActive()) {
                return BaublesApi.getBaublesHandler((EntityPlayer)player);
            }
            throw new IllegalArgumentException("Tried to receive bauble item, but bauble is not loaded");
        }
    };

    @ApiStatus.Internal
    public static void init() {
    }

    public static Collection<InventoryType> getAll() {
        return InventoryType.getAll();
    }

    @Nullable
    public static SlotFindResult findFirstStackable(EntityPlayer player, ItemStack stack) {
        for (InventoryType type : InventoryTypes.getAll()) {
            int i = type.findFirstStackable(player, stack);
            if (i < 0) continue;
            return new SlotFindResult(type, i);
        }
        return null;
    }

    public static void visitAllStackable(EntityPlayer player, ItemStack stack, InventoryVisitor visitor) {
        for (InventoryType type : InventoryTypes.getAll()) {
            if (!type.visitAllStackable(player, stack, visitor)) continue;
            return;
        }
    }

    public static void visitAll(EntityPlayer player, InventoryVisitor visitor) {
        for (InventoryType type : InventoryTypes.getAll()) {
            if (!type.visitAll(player, visitor)) continue;
            return;
        }
    }

    public static class SlotFindResult {
        public final InventoryType type;
        public final int slot;

        public SlotFindResult(InventoryType type, int slot) {
            this.type = type;
            this.slot = slot;
        }
    }
}

