/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class PairList<T1, T2>
implements Iterable<Pair<T1, T2>> {
    private final List<T1> l1 = new ArrayList<T1>();
    private final List<T2> l2 = new ArrayList<T2>();

    public void add(T1 t1, T2 t2) {
        this.l1.add(t1);
        this.l2.add(t2);
    }

    public int size() {
        return this.l1.size();
    }

    public boolean isEmpty() {
        return this.l1.isEmpty();
    }

    public T1 getLeft(int index) {
        return this.l1.get(index);
    }

    public T2 getRight(int index) {
        return this.l2.get(index);
    }

    public Pair<T1, T2> get(int index) {
        return Pair.of(this.getLeft(index), this.getRight(index));
    }

    @Override
    @NotNull
    public Iterator<Pair<T1, T2>> iterator() {
        return new AbstractIterator<Pair<T1, T2>>(){
            private final MutablePair<T1, T2> pair = MutablePair.of(null, null);
            private int index = -1;

            protected Pair<T1, T2> computeNext() {
                if (++this.index == PairList.this.size()) {
                    return (Pair)this.endOfData();
                }
                this.pair.setLeft(PairList.this.getLeft(this.index));
                this.pair.setRight(PairList.this.getRight(this.index));
                return this.pair;
            }
        };
    }
}

