/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderWorld
implements IBlockAccess {
    private final ISchema schema;
    private final World world;

    public RenderWorld(ISchema schema) {
        this.schema = schema;
        this.world = schema.getWorld();
    }

    @Nullable
    public TileEntity getTileEntity(@NotNull BlockPos pos) {
        if (this.schema == null) {
            return this.world.getTileEntity(pos);
        }
        BlockInfo.Mut.SHARED.set((IBlockAccess)this.world, pos);
        return this.schema.getRenderFilter().test(pos, BlockInfo.Mut.SHARED) ? BlockInfo.Mut.SHARED.getTileEntity() : null;
    }

    public int getCombinedLight(@NotNull BlockPos pos, int lightValue) {
        return this.world.getCombinedLight(pos, lightValue);
    }

    @NotNull
    public IBlockState getBlockState(@NotNull BlockPos pos) {
        if (this.schema == null) {
            return this.world.getBlockState(pos);
        }
        BlockInfo.Mut.SHARED.set((IBlockAccess)this.world, pos);
        return this.schema.getRenderFilter().test(pos, BlockInfo.Mut.SHARED) ? BlockInfo.Mut.SHARED.getBlockState() : Blocks.AIR.getDefaultState();
    }

    public boolean isAirBlock(@NotNull BlockPos pos) {
        IBlockState state = this.getBlockState(pos);
        return state.getBlock().isAir(state, (IBlockAccess)this, pos);
    }

    @NotNull
    public Biome getBiome(@NotNull BlockPos pos) {
        return this.world.getBiome(pos);
    }

    public int getStrongPower(@NotNull BlockPos pos, @NotNull EnumFacing direction) {
        return this.world.getStrongPower(pos, direction);
    }

    @NotNull
    public WorldType getWorldType() {
        return this.world.getWorldType();
    }

    public boolean isSideSolid(@NotNull BlockPos pos, @NotNull EnumFacing side, boolean _default) {
        if (!this.world.isValid(pos)) {
            return _default;
        }
        Chunk chunk = this.world.getChunk(pos);
        if (chunk == null || chunk.isEmpty()) {
            return _default;
        }
        return this.getBlockState(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

