/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.value.IValue;
import com.cleanroommc.modularui.api.widget.IDragResizeable;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.INotifyEnabled;
import com.cleanroommc.modularui.api.widget.IPositioned;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.ITooltip;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.theme.WidgetThemeKey;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widget.sizer.IUnResizeable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Widget<W extends Widget<W>>
implements IWidget,
IPositioned<W>,
ITooltip<W>,
ISynced<W> {
    @Nullable
    private String debugName;
    private boolean enabled = true;
    private boolean excludeAreaInRecipeViewer = false;
    private boolean valid = false;
    private IWidget parent = null;
    private ModularPanel panel = null;
    private ModularGuiContext context = null;
    private final Area area = new Area();
    private final Flex flex = new Flex(this);
    private IResizeable resizer = this.flex;
    private BiConsumer<W, IViewportStack> transform;
    private boolean requiresResize = false;
    @Nullable
    private IValue<?> value;
    @Nullable
    private String syncKey;
    @Nullable
    private SyncHandler syncHandler;
    @Nullable
    private IDrawable background = null;
    @Nullable
    private IDrawable overlay = null;
    @Nullable
    private IDrawable hoverBackground = null;
    @Nullable
    private IDrawable hoverOverlay = null;
    @Nullable
    private RichTooltip tooltip;
    @Nullable
    private WidgetThemeKey<?> widgetThemeOverride = null;
    @Nullable
    private List<IGuiAction> guiActionListeners;
    @Nullable
    private Consumer<W> onUpdateListener;

    @Override
    @ApiStatus.Internal
    public final void initialise(@NotNull IWidget parent, boolean late) {
        if (!(this instanceof ModularPanel)) {
            this.parent = parent;
            this.panel = parent.getPanel();
            this.context = parent.getContext();
            this.getArea().setPanelLayer(this.panel.getArea().getPanelLayer());
            this.getArea().z(parent.getArea().z() + 1);
            if (this.guiActionListeners != null) {
                for (IGuiAction action : this.guiActionListeners) {
                    this.context.getScreen().registerGuiActionListener(action);
                }
            }
        }
        if (this.value != null && this.syncKey != null) {
            throw new IllegalStateException("Widget has a value and a sync key for a synced value. This is not allowed!");
        }
        this.valid = true;
        if (!this.getScreen().isClientOnly()) {
            this.initialiseSyncHandler(this.getScreen().getSyncManager(), late);
        }
        if (this.isExcludeAreaInRecipeViewer()) {
            this.getContext().getRecipeViewerSettings().addRecipeViewerExclusionArea(this);
        }
        this.onInit();
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.initialise(this, false);
            }
        }
        this.afterInit();
        this.requiresResize = false;
    }

    @ApiStatus.OverrideOnly
    public void onInit() {
    }

    @ApiStatus.OverrideOnly
    public void afterInit() {
    }

    @Override
    public void initialiseSyncHandler(ModularSyncManager syncManager, boolean late) {
        ValueSyncHandler valueSyncHandler;
        if (this.syncKey != null) {
            this.syncHandler = syncManager.getSyncHandler(this.getPanel().getName(), this.syncKey);
        }
        if (!(this.syncKey == null && this.syncHandler == null || this.isValidSyncHandler(this.syncHandler))) {
            String type = this.syncHandler == null ? null : this.syncHandler.getClass().getName();
            this.syncHandler = null;
            throw new IllegalStateException("SyncHandler of type " + type + " is not valid for " + this.getClass().getName() + ", with key " + this.syncKey);
        }
        SyncHandler syncHandler = this.syncHandler;
        if (syncHandler instanceof ValueSyncHandler && (valueSyncHandler = (ValueSyncHandler)syncHandler).getChangeListener() == null) {
            valueSyncHandler.setChangeListener(this::markTooltipDirty);
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.isValid()) {
            if (this.guiActionListeners != null) {
                for (IGuiAction action : this.guiActionListeners) {
                    this.context.getScreen().removeGuiActionListener(action);
                }
            }
            if (this.isExcludeAreaInRecipeViewer()) {
                this.getContext().getRecipeViewerSettings().removeRecipeViewerExclusionArea(this);
            }
        }
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.dispose();
            }
        }
        if (!(this instanceof ModularPanel)) {
            this.panel = null;
            this.parent = null;
            this.context = null;
        }
        this.valid = false;
    }

    @Override
    public void drawBackground(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        IDrawable bg = this.getCurrentBackground(context.getTheme(), widgetTheme);
        if (bg != null) {
            bg.drawAtZero(context, this.getArea().width, this.getArea().height, this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        IDrawable bg = this.getCurrentOverlay(context.getTheme(), widgetTheme);
        if (bg != null) {
            bg.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(context);
        }
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getOverlay() {
        return this.overlay;
    }

    @Nullable
    public IDrawable getHoverBackground() {
        return this.hoverBackground;
    }

    @Nullable
    public IDrawable getHoverOverlay() {
        return this.hoverOverlay;
    }

    @Nullable
    public IDrawable getCurrentBackground(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        IDrawable background;
        if (this.isHovering()) {
            IDrawable hoverBackground = this.getHoverBackground();
            if (hoverBackground == null) {
                hoverBackground = this.getActiveWidgetTheme(widgetTheme, true).getBackground();
            }
            if (hoverBackground != null && hoverBackground != IDrawable.NONE) {
                return hoverBackground;
            }
        }
        return (background = this.getBackground()) == null ? this.getActiveWidgetTheme(widgetTheme, false).getBackground() : background;
    }

    @Nullable
    public IDrawable getCurrentOverlay(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        IDrawable hoverBackground = this.getHoverOverlay();
        return hoverBackground != null && hoverBackground != IDrawable.NONE && this.isHovering() ? hoverBackground : this.getOverlay();
    }

    @Override
    @Nullable
    public RichTooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public RichTooltip tooltip() {
        if (this.tooltip == null) {
            this.tooltip = new RichTooltip().parent(this);
        }
        return this.tooltip;
    }

    @Override
    public W tooltip(RichTooltip tooltip) {
        this.tooltip = tooltip;
        return (W)this.getThis();
    }

    @Override
    public void markTooltipDirty() {
        if (this.tooltip != null) {
            this.tooltip.markDirty();
        }
    }

    @ApiStatus.OverrideOnly
    protected WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getFallback();
    }

    @ApiStatus.OverrideOnly
    protected WidgetTheme getActiveWidgetTheme(WidgetThemeEntry<?> widgetTheme, boolean hover) {
        return widgetTheme.getTheme(hover);
    }

    @Override
    @ApiStatus.NonExtendable
    public final WidgetThemeEntry<?> getWidgetTheme(ITheme theme) {
        if (this.widgetThemeOverride != null) {
            return theme.getWidgetTheme(this.widgetThemeOverride);
        }
        return this.getWidgetThemeInternal(theme);
    }

    @ApiStatus.NonExtendable
    public final <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(ITheme theme, Class<T> expectedType) {
        WidgetThemeEntry<?> entry = this.getWidgetTheme(theme);
        if (entry.getKey().isOfType(expectedType)) {
            return entry;
        }
        throw new IllegalStateException(String.format("Got widget theme with invalid type in widget '%s'. Got type '%s', but expected type '%s'!", this, entry.getKey().getWidgetThemeType().getSimpleName(), expectedType.getSimpleName()));
    }

    public W background(IDrawable ... background) {
        this.background = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W overlay(IDrawable ... overlay) {
        this.overlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W hoverBackground(IDrawable ... background) {
        this.hoverBackground = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W hoverOverlay(IDrawable ... overlay) {
        this.hoverOverlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W disableHoverBackground() {
        return this.hoverBackground(IDrawable.NONE);
    }

    public W disableHoverOverlay() {
        return this.hoverOverlay(IDrawable.NONE);
    }

    public W widgetTheme(String s) {
        WidgetThemeKey<?> widgetThemeKey = WidgetThemeKey.getFromFullName(s);
        if (widgetThemeKey == null) {
            throw new IllegalArgumentException("No widget theme for id '" + s + "' exists.");
        }
        return this.widgetTheme(widgetThemeKey);
    }

    public W widgetTheme(WidgetThemeKey<?> s) {
        this.widgetThemeOverride = s;
        return (W)this.getThis();
    }

    @Override
    @MustBeInvokedByOverriders
    public void onUpdate() {
        if (this.onUpdateListener != null) {
            this.onUpdateListener.accept(this.getThis());
        }
    }

    @Nullable
    public Consumer<W> getOnUpdateListener() {
        return this.onUpdateListener;
    }

    public W listenGuiAction(IGuiAction action) {
        if (this.guiActionListeners == null) {
            this.guiActionListeners = new ArrayList<IGuiAction>();
        }
        this.guiActionListeners.add(action);
        if (this.isValid()) {
            this.context.getScreen().registerGuiActionListener(action);
        }
        return (W)this.getThis();
    }

    public W onUpdateListener(Consumer<W> listener) {
        return this.onUpdateListener(listener, false);
    }

    public W onUpdateListener(Consumer<W> listener, boolean merge) {
        if (merge && this.onUpdateListener != null) {
            Consumer oldListener = this.onUpdateListener;
            if (listener != null) {
                this.onUpdateListener = w -> {
                    oldListener.accept(w);
                    listener.accept(w);
                };
            }
        } else {
            this.onUpdateListener = listener;
        }
        return (W)this.getThis();
    }

    public W setEnabledIf(Predicate<W> condition) {
        return (W)this.onUpdateListener(w -> this.setEnabled(condition.test(w)), true);
    }

    @Override
    public int getDefaultWidth() {
        return this.isValid() ? ((WidgetTheme)this.getWidgetTheme(this.getContext().getTheme()).getTheme()).getDefaultWidth() : 18;
    }

    @Override
    public int getDefaultHeight() {
        return this.isValid() ? ((WidgetTheme)this.getWidgetTheme(this.getContext().getTheme()).getTheme()).getDefaultHeight() : 18;
    }

    @Override
    public void scheduleResize() {
        this.requiresResize = true;
    }

    @Override
    public boolean requiresResize() {
        return this.requiresResize;
    }

    @Override
    @MustBeInvokedByOverriders
    public void onResized() {
        this.requiresResize = false;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public Flex getFlex() {
        return this.flex;
    }

    @Override
    public Flex flex() {
        return this.getFlex();
    }

    @Override
    @NotNull
    public IResizeable resizer() {
        return this.resizer;
    }

    @Override
    public void resizer(IResizeable resizer) {
        this.resizer = resizer != null ? resizer : IUnResizeable.INSTANCE;
    }

    @Override
    public void transform(IViewportStack stack) {
        IWidget.super.transform(stack);
        if (this.transform != null) {
            this.transform.accept(this.getThis(), stack);
        }
    }

    public W transform(BiConsumer<W, IViewportStack> transform) {
        this.transform = transform;
        return (W)this.getThis();
    }

    @Override
    public final boolean isValid() {
        return this.valid;
    }

    @Override
    public ModularScreen getScreen() {
        return this.getPanel().getScreen();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        if (!this.isValid()) {
            throw new IllegalStateException(this + " is not in a valid state!");
        }
        return this.panel;
    }

    @Override
    @NotNull
    public IWidget getParent() {
        if (!this.isValid()) {
            throw new IllegalStateException(this + " is not in a valid state!");
        }
        return this.parent;
    }

    @Override
    public ModularGuiContext getContext() {
        if (!this.isValid()) {
            throw new IllegalStateException(this + " is not in a valid state!");
        }
        return this.context;
    }

    @ApiStatus.Internal
    protected final void setContext(ModularGuiContext context) {
        this.context = context;
    }

    @Override
    public boolean isSynced() {
        return this.syncHandler != null;
    }

    @Override
    @NotNull
    public SyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised or not synced!");
        }
        return this.syncHandler;
    }

    @Nullable
    public IValue<?> getValue() {
        return this.value;
    }

    @Override
    public W syncHandler(String name, int id) {
        this.syncKey = ModularSyncManager.makeSyncKey(name, id);
        return (W)this.getThis();
    }

    protected void setValue(IValue<?> value) {
        this.value = value;
        if (value instanceof SyncHandler) {
            SyncHandler syncHandler1 = (SyncHandler)((Object)value);
            this.setSyncHandler(syncHandler1);
        }
    }

    protected void setSyncHandler(@Nullable SyncHandler syncHandler) {
        this.syncHandler = syncHandler;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            IWidget iWidget;
            this.enabled = enabled;
            if (this.isValid() && (iWidget = this.getParent()) instanceof INotifyEnabled) {
                INotifyEnabled notifyEnabled = (INotifyEnabled)((Object)iWidget);
                notifyEnabled.onChildChangeEnabled(this, enabled);
            }
        }
    }

    public W disabled() {
        this.setEnabled(false);
        return (W)this.getThis();
    }

    @Override
    public Object getAdditionalHoverInfo(IViewportStack viewportStack, int mouseX, int mouseY) {
        Widget widget = this;
        if (widget instanceof IDragResizeable) {
            IDragResizeable dragResizeable = (IDragResizeable)((Object)widget);
            return IDragResizeable.getDragResizeCorner(dragResizeable, this.getArea(), viewportStack, mouseX, mouseY);
        }
        return null;
    }

    public boolean isExcludeAreaInRecipeViewer() {
        return this.excludeAreaInRecipeViewer;
    }

    public W excludeAreaInRecipeViewer() {
        return this.excludeAreaInRecipeViewer(true);
    }

    public W excludeAreaInRecipeViewer(boolean val) {
        this.excludeAreaInRecipeViewer = val;
        if (this.isValid()) {
            this.getContext().getRecipeViewerSettings().addRecipeViewerExclusionArea(this);
        }
        return (W)this.getThis();
    }

    public W debugName(String name) {
        this.debugName = name;
        return (W)this.getThis();
    }

    @Override
    public W getThis() {
        return (W)this;
    }

    public String toString() {
        if (this.debugName != null) {
            return this.getClass().getSimpleName() + "#" + this.debugName;
        }
        return this.getClass().getSimpleName();
    }
}

