/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollPadding;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollArea
extends Area {
    private HorizontalScrollData scrollX;
    private VerticalScrollData scrollY;
    private final ScrollPadding scrollPadding = new ScrollPadding();
    private int scrollBarBackgroundColor;

    public ScrollArea(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    public ScrollArea() {
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    @Override
    public Box getPadding() {
        return this.scrollPadding;
    }

    public ScrollPadding getScrollPadding() {
        return this.scrollPadding;
    }

    public void setScrollData(ScrollData data) {
        if (data instanceof HorizontalScrollData) {
            HorizontalScrollData scrollData;
            this.scrollX = scrollData = (HorizontalScrollData)data;
        } else if (data instanceof VerticalScrollData) {
            VerticalScrollData scrollData;
            this.scrollY = scrollData = (VerticalScrollData)data;
        }
    }

    public void removeScrollData() {
        this.scrollX = null;
        this.scrollY = null;
    }

    public void setScrollDataX(HorizontalScrollData scrollX) {
        this.scrollX = scrollX;
    }

    public void setScrollDataY(VerticalScrollData data) {
        this.scrollY = data;
    }

    public HorizontalScrollData getScrollX() {
        return this.scrollX;
    }

    public VerticalScrollData getScrollY() {
        return this.scrollY;
    }

    public ScrollData getScrollData(GuiAxis axis) {
        return axis.isVertical() ? this.scrollY : this.scrollX;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(GuiContext context) {
        return this.mouseClicked(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public boolean mouseClicked(int x, int y) {
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return this.scrollX.onMouseClicked(this, x, y, 0);
        }
        if (this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y)) {
            return this.scrollY.onMouseClicked(this, y, x, 0);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseScroll(GuiContext context) {
        return this.mouseScroll(context.getAbsMouseX(), context.getAbsMouseY(), context.getMouseWheel(), GuiScreen.isShiftKeyDown());
    }

    public boolean mouseScroll(int x, int y, int scroll, boolean shift) {
        ScrollData data;
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null) {
            data = this.scrollY == null || shift ? this.scrollX : this.scrollY;
        } else if (this.scrollY != null) {
            data = this.scrollY;
        } else {
            return false;
        }
        int scrollAmount = (int)Math.copySign(data.getScrollSpeed(), scroll);
        int scrollTo = data.isAnimating() ? data.getAnimatingTo() - scrollAmount : data.getScroll() - scrollAmount;
        int oldScroll = data.getScroll();
        data.scrollTo(this, scrollTo);
        boolean changed = data.getScroll() != oldScroll;
        data.scrollTo(this, oldScroll);
        if (changed) {
            data.animateTo(this, scrollTo);
            return true;
        }
        return data.isCancelScrollEdge();
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseReleased(GuiContext context) {
        this.mouseReleased(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public void mouseReleased(int x, int y) {
        if (this.scrollX != null) {
            this.scrollX.dragging = false;
            this.scrollX.clickOffset = 0;
        }
        if (this.scrollY != null) {
            this.scrollY.dragging = false;
            this.scrollY.clickOffset = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drag(GuiContext context) {
        this.drag(context.getMouseX(), context.getMouseY());
    }

    public void drag(int x, int y) {
        float progress;
        ScrollData data;
        if (this.scrollX != null && this.scrollX.dragging) {
            data = this.scrollX;
            progress = data.getProgress(this, x, y);
        } else if (this.scrollY != null && this.scrollY.dragging) {
            data = this.scrollY;
            progress = data.getProgress(this, y, x);
        } else {
            return;
        }
        progress = MathUtils.clamp(progress, 0.0f, 1.0f);
        data.scrollTo(this, (int)(progress * (float)(data.getScrollSize() - data.getVisibleSize(this) + data.getThickness())));
    }

    public boolean isInsideScrollbarArea(int x, int y) {
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return true;
        }
        return this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y);
    }

    public boolean isScrollBarXActive() {
        return this.scrollX != null && this.scrollX.isScrollBarActive(this);
    }

    public boolean isScrollBarYActive() {
        return this.scrollY != null && this.scrollY.isScrollBarActive(this);
    }

    public int getScrollBarBackgroundColor() {
        return this.scrollBarBackgroundColor;
    }

    public void setScrollBarBackgroundColor(int scrollBarBackgroundColor) {
        this.scrollBarBackgroundColor = scrollBarBackgroundColor;
    }

    public boolean isDragging() {
        return this.scrollX != null && this.scrollX.isDragging() || this.scrollY != null && this.scrollY.isDragging();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScrollbar() {
        boolean isXActive = false;
        if (this.scrollX != null && this.scrollX.isScrollBarActive(this, false)) {
            isXActive = true;
            this.scrollX.drawScrollbar(this);
        }
        if (this.scrollY != null && this.scrollY.isScrollBarActive(this, isXActive)) {
            this.scrollY.drawScrollbar(this);
        }
    }
}

