/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.ElementAtTheEnd;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

class CloneCache {
    private final HashMap<Argument, Argument> argumentClones = new HashMap();
    private final HashMap<Function, Function> functionClones = new HashMap();
    private final HashMap<Constant, Constant> constantClones = new HashMap();
    private final HashMap<Expression, Expression> expressionClones = new HashMap();
    private final Set<PrimitiveElement> cloneInProgress = new HashSet<PrimitiveElement>();
    private final List<ElementAtTheEnd<Argument>> argumentsToAddCloneAtTheEnd = new ArrayList<ElementAtTheEnd<Argument>>();
    private final List<ElementAtTheEnd<Function>> functionsToAddCloneAtTheEnd = new ArrayList<ElementAtTheEnd<Function>>();
    private final List<ElementAtTheEnd<Constant>> constantsToAddCloneAtTheEnd = new ArrayList<ElementAtTheEnd<Constant>>();

    CloneCache() {
    }

    void clearCache() {
        this.argumentClones.clear();
        this.functionClones.clear();
        this.constantClones.clear();
        this.expressionClones.clear();
        this.cloneInProgress.clear();
        this.argumentsToAddCloneAtTheEnd.clear();
        this.functionsToAddCloneAtTheEnd.clear();
        this.constantsToAddCloneAtTheEnd.clear();
    }

    void cacheArgumentToAddCloneAtTheEnd(List<Argument> argumentsList, Argument argumentBeingCloned, int addAtIndex) {
        this.argumentsToAddCloneAtTheEnd.add(new ElementAtTheEnd<Argument>(argumentsList, argumentBeingCloned, addAtIndex));
    }

    void cacheFunctionToAddCloneAtTheEnd(List<Function> functionsList, Function functionBeingCloned, int addAtIndex) {
        this.functionsToAddCloneAtTheEnd.add(new ElementAtTheEnd<Function>(functionsList, functionBeingCloned, addAtIndex));
    }

    void cacheConstantToAddCloneAtTheEnd(List<Constant> constantsList, Constant constantBeingCloned, int addAtIndex) {
        this.constantsToAddCloneAtTheEnd.add(new ElementAtTheEnd<Constant>(constantsList, constantBeingCloned, addAtIndex));
    }

    void addAllAtTheEndElements() {
        for (ElementAtTheEnd<Argument> elementAtTheEnd : this.argumentsToAddCloneAtTheEnd) {
            Argument argumentClone = this.getArgumentClone((Argument)elementAtTheEnd.elementBeingCloned);
            elementAtTheEnd.targetElementsList.set(elementAtTheEnd.addAtIndex, argumentClone);
        }
        for (ElementAtTheEnd<PrimitiveElement> elementAtTheEnd : this.functionsToAddCloneAtTheEnd) {
            Function functionClone = this.getFunctionClone((Function)elementAtTheEnd.elementBeingCloned);
            elementAtTheEnd.targetElementsList.set(elementAtTheEnd.addAtIndex, functionClone);
        }
        for (ElementAtTheEnd<PrimitiveElement> elementAtTheEnd : this.constantsToAddCloneAtTheEnd) {
            Constant constantClone = this.getConstantClone((Constant)elementAtTheEnd.elementBeingCloned);
            elementAtTheEnd.targetElementsList.set(elementAtTheEnd.addAtIndex, constantClone);
        }
    }

    void cacheCloneInProgress(PrimitiveElement elementBeingCloned) {
        this.cloneInProgress.add(elementBeingCloned);
    }

    boolean isCloneInProgress(PrimitiveElement element) {
        return this.cloneInProgress.contains(element);
    }

    void clearCloneInProgress(PrimitiveElement elementBeingCloned) {
        this.cloneInProgress.remove(elementBeingCloned);
    }

    void cacheArgumentClone(Argument arg, Argument argClone) {
        this.argumentClones.put(arg, argClone);
    }

    void cacheFunctionClone(Function fun, Function funClone) {
        this.functionClones.put(fun, funClone);
    }

    void cacheConstantClone(Constant con, Constant conClone) {
        this.constantClones.put(con, conClone);
    }

    void cacheExpressionClone(Expression expr, Expression exprClone) {
        this.expressionClones.put(expr, exprClone);
    }

    Argument getArgumentClone(Argument arg) {
        return this.argumentClones.get(arg);
    }

    Function getFunctionClone(Function fun) {
        return this.functionClones.get(fun);
    }

    Constant getConstantClone(Constant con) {
        return this.constantClones.get(con);
    }

    Expression getExpressionClone(Expression expr) {
        return this.expressionClones.get(expr);
    }
}

