/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.integration.jei;

import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.integration.jei.ModularUIProperties;
import com.cleanroommc.modularui.integration.recipeviewer.RecipeViewerIngredientProvider;
import java.awt.Rectangle;
import java.util.List;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.api.gui.IGuiScreenHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularScreenJEIHandler<T extends GuiScreen>
implements IGhostIngredientHandler<T>,
IGuiScreenHandler<T> {
    private final Class<T> clazz;

    public static <T extends GuiScreen, T2 extends GuiContainer> void register(Class<T> clz, IModRegistry registry) {
        if (GuiContainer.class.isAssignableFrom(clz)) {
            new ContainerScreen(clz).register(registry);
        } else {
            new ModularScreenJEIHandler<T>(clz).register(registry);
        }
    }

    private ModularScreenJEIHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void register(IModRegistry registry) {
        registry.addGhostIngredientHandler(this.clazz, (IGhostIngredientHandler)this);
        registry.addGuiScreenHandler(this.clazz, (IGuiScreenHandler)this);
    }

    @NotNull
    public Class<T> getGuiContainerClass() {
        return this.clazz;
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(T gui, @NotNull I ingredient, boolean doStart) {
        return ((IMuiScreen)gui).getScreen().getContext().getRecipeViewerSettings().getAllGhostIngredientTargets(ingredient);
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return false;
    }

    @Nullable
    public IGuiProperties apply(@NotNull T guiScreen) {
        return ((IMuiScreen)guiScreen).getScreen().getContext().getRecipeViewerSettings().isRecipeViewerEnabled(((IMuiScreen)guiScreen).getScreen()) ? new ModularUIProperties((IMuiScreen)guiScreen) : null;
    }

    public static class ContainerScreen<T extends GuiContainer>
    extends ModularScreenJEIHandler<T>
    implements IAdvancedGuiHandler<T> {
        private ContainerScreen(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void register(IModRegistry registry) {
            super.register(registry);
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{this});
        }

        @Nullable
        public List<Rectangle> getGuiExtraAreas(@NotNull T guiContainer) {
            return ((IMuiScreen)guiContainer).getScreen().getContext().getRecipeViewerSettings().getAllRecipeViewerExclusionAreas();
        }

        @Nullable
        public Object getIngredientUnderMouse(@NotNull T guiContainer, int mouseX, int mouseY) {
            Object object;
            IWidget hovered = ((IMuiScreen)guiContainer).getScreen().getContext().getHovered();
            if (hovered instanceof RecipeViewerIngredientProvider) {
                RecipeViewerIngredientProvider jip = (RecipeViewerIngredientProvider)((Object)hovered);
                object = jip.getIngredient();
            } else {
                object = null;
            }
            return object;
        }
    }
}

